/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.commands.CommandSourceStack.ABI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.command.ColorArgumentType;
import moe.plushie.armourers_workshop.init.command.ColorSchemeArgumentType;
import moe.plushie.armourers_workshop.init.command.FileArgumentType;
import moe.plushie.armourers_workshop.init.command.ListArgumentType;
import moe.plushie.armourers_workshop.init.command.ReflectArgumentBuilder;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.event.common.RegisterCommandsEvent;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModCommands {
    private static final HashMap<String, ISkinPaintType> DYE_TYPES = (HashMap)Util.m_137537_(() -> {
        HashMap<String, SkinPaintType> map = new HashMap<String, SkinPaintType>();
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.getRegistryName().m_135815_();
            map.put(name.replaceAll("_", ""), paintType);
        }
        return map;
    });
    private static final DynamicCommandExceptionType ERROR_MISSING_DYE_SLOT = new DynamicCommandExceptionType(ob -> Component.m_237110_((String)"commands.armourers_workshop.armourers.error.missingSkin", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_MISSING_SKIN = new DynamicCommandExceptionType(ob -> Component.m_237110_((String)"commands.armourers_workshop.armourers.error.missingSkin", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_MISSING_ITEM_STACK = new DynamicCommandExceptionType(ob -> Component.m_237110_((String)"commands.armourers_workshop.armourers.error.missingItemSkinnable", (Object[])new Object[]{ob}));

    public static void init(RegisterCommandsEvent event) {
        event.register(ModCommands.commands());
    }

    public static LiteralArgumentBuilder<CommandSourceStack> commands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"armourers").then(ReflectArgumentBuilder.literal("config", ModConfig.Client.class))).then(ReflectArgumentBuilder.literal("debug", ModDebugger.class))).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"library").then(Commands.m_82127_((String)"reload").executes(Executor::reloadLibrary)))).then(Commands.m_82127_((String)"setSkin").then(ModCommands.entities().then(ModCommands.slots().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))).then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))))).then(Commands.m_82127_((String)"giveSkin").then(ModCommands.players().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::giveSkin)).executes(Executor::giveSkin))))).then(Commands.m_82127_((String)"clearSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().executes(Executor::clearSkin))).executes(Executor::clearSkin)))).then(Commands.m_82127_((String)"exportSkin").then(ModCommands.skinFormats().then(ModCommands.outputFileName().then(ModCommands.scale().executes(Executor::exportSkin)).executes(Executor::exportSkin))))).then(Commands.m_82127_((String)"setColor").then(ModCommands.entities().then(ModCommands.dyesSlotNames().then(ModCommands.dyeColor().executes(Executor::setColor)))))).then(Commands.m_82127_((String)"rsyncWardrobe").then(ModCommands.players().executes(Executor::resyncWardrobe)))).then(Commands.m_82127_((String)"openWardrobe").then(ModCommands.entities().executes(Executor::openWardrobe)))).then(Commands.m_82127_((String)"itemSkinnable").then(ModCommands.addOrRemote().then(ModCommands.overrideTypes().executes(Executor::setItemSkinnable))))).then(Commands.m_82127_((String)"setUnlockedSlots").then(ModCommands.entities().then(ModCommands.resizableSlotNames().then(ModCommands.resizableSlotAmounts().executes(Executor::setUnlockedWardrobeSlots)))));
    }

    static ArgumentBuilder<CommandSourceStack, ?> players() {
        return Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_());
    }

    static ArgumentBuilder<CommandSourceStack, ?> entities() {
        return Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_());
    }

    static ArgumentBuilder<CommandSourceStack, ?> slots() {
        return Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<CommandSourceStack, ?> skinFormats() {
        return Commands.m_82129_((String)"format", (ArgumentType)ListArgumentType.list(SkinExportManager.getExporters()));
    }

    static ArgumentBuilder<CommandSourceStack, ?> skinDying() {
        return Commands.m_82129_((String)"dying", (ArgumentType)new ColorSchemeArgumentType());
    }

    static ArgumentBuilder<CommandSourceStack, ?> dyesSlotNames() {
        return Commands.m_82129_((String)"dye_slot", (ArgumentType)new ListArgumentType(DYE_TYPES.keySet()));
    }

    static ArgumentBuilder<CommandSourceStack, ?> dyeColor() {
        return Commands.m_82129_((String)"color", (ArgumentType)new ColorArgumentType());
    }

    static ArgumentBuilder<CommandSourceStack, ?> scale() {
        return Commands.m_82129_((String)"scale", (ArgumentType)FloatArgumentType.floatArg());
    }

    static ArgumentBuilder<CommandSourceStack, ?> outputFileName() {
        return Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<CommandSourceStack, ?> resizableSlotAmounts() {
        return Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<CommandSourceStack, ?> resizableSlotNames() {
        return Commands.m_82129_((String)"slot_name", (ArgumentType)new ListArgumentType(ObjectUtils.compactMap(SkinSlotType.values(), slotType -> {
            if (slotType.isResizable()) {
                return slotType.getName();
            }
            return null;
        })));
    }

    static ArgumentBuilder<CommandSourceStack, ?> slotNames() {
        return Commands.m_82129_((String)"slot_name", (ArgumentType)new ListArgumentType(ObjectUtils.map(SkinSlotType.values(), SkinSlotType::getName)));
    }

    static ArgumentBuilder<CommandSourceStack, ?> overrideTypes() {
        return Commands.m_82129_((String)"skin_type", (ArgumentType)new ListArgumentType(ObjectUtils.map(ItemOverrideType.values(), ItemOverrideType::getName)));
    }

    static ArgumentBuilder<CommandSourceStack, ?> skins() {
        return Commands.m_82129_((String)"skin", (ArgumentType)new FileArgumentType(EnvironmentManager.getSkinLibraryDirectory()));
    }

    static ArgumentBuilder<CommandSourceStack, ?> addOrRemote() {
        return Commands.m_82129_((String)"operator", (ArgumentType)new ListArgumentType(Lists.newArrayList((Object[])new String[]{"add", "remove"})));
    }

    private static class Executor {
        private Executor() {
        }

        static int reloadLibrary(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            SkinLibraryManager.getServer().start();
            return 0;
        }

        static boolean containsNode(CommandContext<CommandSourceStack> context, String name) {
            for (ParsedCommandNode node : context.getNodes()) {
                if (!name.equals(node.getNode().getName())) continue;
                return true;
            }
            return false;
        }

        static int setColor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            ISkinPaintType paintType = DYE_TYPES.get(ListArgumentType.getString(context, "dye_slot"));
            if (paintType == null) {
                throw ERROR_MISSING_DYE_SLOT.create(null);
            }
            PaintColor paintColor = ColorArgumentType.getColor(context, "color");
            for (Entity entity : EntityArgument.m_91461_(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                int slot = SkinSlotType.getDyeSlotIndex(paintType);
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.BOTTLE.get());
                ColorUtils.setColor(itemStack, paintColor);
                Container inventory = wardrobe.getInventory();
                inventory.m_6836_(slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int giveSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            if (descriptor.isEmpty()) {
                return 0;
            }
            ItemStack itemStack = descriptor.asItemStack();
            for (Player player : EntityArgument.m_91477_(context, (String)"targets")) {
                moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI.giveItem(player, itemStack);
                ABI.sendSuccess((CommandSourceStack)context.getSource(), (Component)Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, itemStack.m_41611_(), player.m_5446_()}), true);
            }
            return 1;
        }

        static int setSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            if (descriptor.isEmpty()) {
                return 0;
            }
            ItemStack itemStack = descriptor.asItemStack();
            for (Entity entity : EntityArgument.m_91461_(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                SkinSlotType slotType = SkinSlotType.byType(descriptor.getType());
                if (slotType == null || wardrobe == null) continue;
                int slot = wardrobe.getFreeSlot(slotType);
                if (Executor.containsNode(context, "slot")) {
                    slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
                }
                wardrobe.setItem(slotType, slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int clearSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.m_91461_(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                if (!Executor.containsNode(context, "slot")) {
                    wardrobe.clear();
                    wardrobe.broadcast();
                    continue;
                }
                int slot = IntegerArgumentType.getInteger(context, (String)"slot");
                SkinSlotType slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"));
                if (slotType == null) continue;
                wardrobe.setItem(slotType, slot - 1, ItemStack.f_41583_);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int exportSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            String format = ListArgumentType.getString(context, "format");
            String filename = StringArgumentType.getString(context, (String)"name");
            float scale = 1.0f;
            if (Executor.containsNode(context, "scale")) {
                scale = FloatArgumentType.getFloat(context, (String)"scale");
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack itemStack = player.m_21205_();
            String identifier = SkinDescriptor.of(itemStack).getIdentifier();
            Skin skin = SkinLoader.getInstance().loadSkin(identifier);
            if (skin == null) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            float resolvedScale = scale;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Skin", identifier);
            player.m_213846_((Component)Component.m_237110_((String)"commands.armourers_workshop.armourers.exportSkin.processing", (Object[])new Object[]{filename}));
            UserNotifications.sendSystemToast((Component)Component.m_237115_((String)"commands.armourers_workshop.notify.exportSkin.processing"), tag, (Player)player);
            EnvironmentExecutor.runOnBackground(() -> Executor.lambda$exportSkin$1(skin, format, filename, resolvedScale, (Player)player, tag));
            return 0;
        }

        static int setItemSkinnable(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String operator = ListArgumentType.getString(context, "operator");
            ItemOverrideType overrideType = ItemOverrideType.of(ListArgumentType.getString(context, "skin_type"));
            ItemStack itemStack = player.m_21205_();
            if (overrideType == null || itemStack.m_41619_()) {
                throw ERROR_MISSING_ITEM_STACK.create((Object)player.m_6302_());
            }
            ResourceLocation identifier = TypedRegistry.findKey(itemStack.m_41720_());
            String key = String.format("%s:%s", overrideType.getName(), identifier);
            if (operator.equals("add")) {
                if (ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.add(key);
            } else {
                if (!ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.remove(key);
            }
            ModConfigSpec.COMMON.save();
            String messageKey = "commands.armourers_workshop.armourers.setItemSkinnable." + operator;
            MutableComponent overrideTypeName = TranslateUtils.Name.of(overrideType);
            player.m_213846_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{itemStack.m_41611_(), overrideTypeName}));
            return 1;
        }

        static int resyncWardrobe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
                SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
                if (wardrobe == null) continue;
                wardrobe.broadcast();
            }
            return 1;
        }

        static int openWardrobe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            for (Entity entity : EntityArgument.m_91461_(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                ((IMenuType)ModMenuTypes.WARDROBE_OP.get()).openMenu((Player)player, wardrobe);
                break;
            }
            return 1;
        }

        static int setUnlockedWardrobeSlots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.m_91461_(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int amount = IntegerArgumentType.getInteger(context, (String)"amount");
                wardrobe.setUnlockedSize(slotType, MathUtils.clamp(amount, 0, slotType.getMaxSize()));
                wardrobe.broadcast();
            }
            return 1;
        }

        static SkinDescriptor loadSkinDescriptor(CommandContext<CommandSourceStack> context) {
            String identifier = FileArgumentType.getString(context, "skin");
            if (identifier.isEmpty()) {
                return SkinDescriptor.EMPTY;
            }
            ColorScheme scheme = ColorScheme.EMPTY;
            if (Executor.containsNode(context, "dying")) {
                scheme = ColorSchemeArgumentType.getColorScheme(context, "dying");
            }
            boolean needCopy = false;
            if (identifier.startsWith("/")) {
                identifier = DataDomain.DEDICATED_SERVER.normalize(identifier);
                needCopy = true;
            }
            return SkinLoader.getInstance().loadSkinFromDB(identifier, scheme, needCopy);
        }

        private static /* synthetic */ Runnable lambda$exportSkin$1(Skin skin, String format, String filename, float resolvedScale, Player player, CompoundTag tag) {
            return () -> {
                try {
                    SkinExportManager.exportSkin(skin, format, filename, resolvedScale);
                    player.m_213846_((Component)Component.m_237110_((String)"commands.armourers_workshop.armourers.exportSkin.success", (Object[])new Object[]{filename}));
                    UserNotifications.sendSystemToast((Component)Component.m_237115_((String)"commands.armourers_workshop.notify.exportSkin.success"), tag, player);
                }
                catch (Exception e) {
                    player.m_213846_((Component)Component.m_237110_((String)"commands.armourers_workshop.armourers.exportSkin.failure", (Object[])new Object[]{filename}));
                    UserNotifications.sendSystemToast((Component)Component.m_237115_((String)"commands.armourers_workshop.notify.exportSkin.failure"), tag, player);
                    e.printStackTrace();
                }
            };
        }
    }
}

