/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.player.AbstractClientPlayer.ABI;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerTextureLoader {
    public static final ResourceLocation STEVE_SKIN_LOCATION = new ResourceLocation("textures/entity/steve.png");
    public static final ResourceLocation ALEX_SKIN_LOCATION = new ResourceLocation("textures/entity/alex.png");
    private static final PlayerTextureLoader LOADER = new PlayerTextureLoader();
    private final HashMap<String, Optional<GameProfile>> profiles = new HashMap();
    private final HashMap<PlayerTextureDescriptor, Optional<PlayerTexture>> resolvedTextures = new HashMap();
    private final HashSet<PlayerTextureDescriptor> loadingTextures = new HashSet();
    private final HashMap<String, BakedEntityTexture> downloadedTextures = new HashMap();
    private final HashMap<ResourceLocation, Optional<PlayerTexture>> bakedTextures = new HashMap();
    private final Executor workThread = ThreadUtils.newFixedThreadPool(1, "AW-SKIN/T-LD");

    public static PlayerTextureLoader getInstance() {
        return LOADER;
    }

    public GameProfile getGameProfile(PlayerTextureDescriptor descriptor) {
        GameProfile profile = descriptor.getProfile();
        if (profile != null) {
            return profile;
        }
        String name = descriptor.getName();
        if (name != null) {
            Optional<GameProfile> profile1 = this.profiles.get(name.toLowerCase());
            if (profile1 != null) {
                return profile1.orElse(null);
            }
            this.loadGameProfileWithName(name, null);
        }
        return null;
    }

    @Nullable
    public BakedEntityTexture getTextureModel(ResourceLocation location) {
        if (location == null) {
            return null;
        }
        Optional<PlayerTexture> texture = this.bakedTextures.get(location);
        if (texture != null) {
            return texture.map(PlayerTexture::getTexture).orElse(null);
        }
        this.loadDefaultTexture(location);
        return null;
    }

    public ResourceLocation getTextureLocation(Entity entity) {
        PlayerTextureDescriptor descriptor;
        PlayerTexture texture;
        if (entity instanceof MannequinEntity && (texture = this.loadTexture(descriptor = (PlayerTextureDescriptor)entity.m_20088_().m_135370_(MannequinEntity.DATA_TEXTURE))) != null && texture.getLocation() != null) {
            return texture.getLocation();
        }
        if (entity instanceof AbstractClientPlayer) {
            return ABI.getSkin((AbstractClientPlayer)entity).texture();
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    public ResourceLocation loadTextureLocation(PlayerTextureDescriptor descriptor) {
        PlayerTexture texture1;
        if (!descriptor.isEmpty() && (texture1 = this.loadTexture(descriptor)) != null) {
            return texture1.getLocation();
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    @Nullable
    public PlayerTexture loadTexture(PlayerTextureDescriptor descriptor) {
        if (descriptor.isEmpty()) {
            return null;
        }
        Optional<PlayerTexture> texture = this.resolvedTextures.get(descriptor);
        if (texture != null && texture.isPresent()) {
            return texture.orElse(null);
        }
        this.loadTextureDescriptor(descriptor, descriptor1 -> {});
        return null;
    }

    public void loadTextureDescriptor(PlayerTextureDescriptor descriptor, Consumer<Optional<PlayerTextureDescriptor>> complete) {
        Optional<PlayerTexture> texture = this.resolvedTextures.get(descriptor);
        if (texture != null || descriptor.isEmpty() || !this.loadingTextures.add(descriptor)) {
            complete.accept(Optional.of(descriptor));
            return;
        }
        String url = descriptor.getURL();
        if (url != null) {
            try {
                URL ignored = new URL(url);
                this.loadCustomTextureWithURL(url, resolvedDescriptor -> {
                    this.loadingTextures.remove(descriptor);
                    complete.accept((Optional<PlayerTextureDescriptor>)resolvedDescriptor);
                });
            }
            catch (MalformedURLException e) {
                ModLog.info("input a invalid url '{}'", url);
                complete.accept(Optional.empty());
            }
            return;
        }
        GameProfile profile = descriptor.getProfile();
        if (profile != null) {
            this.loadCustomTextureWithProfile(profile, resolvedDescriptor -> {
                this.loadingTextures.remove(descriptor);
                complete.accept((Optional<PlayerTextureDescriptor>)resolvedDescriptor);
            });
            return;
        }
        String name = descriptor.getName();
        if (name != null) {
            this.loadCustomTextureWithName(name, resolvedDescriptor -> {
                this.loadingTextures.remove(descriptor);
                complete.accept((Optional<PlayerTextureDescriptor>)resolvedDescriptor);
            });
            return;
        }
        if (complete != null) {
            complete.accept(Optional.empty());
        }
    }

    private void loadGameProfileWithName(String name, @Nullable Consumer<Optional<GameProfile>> complete) {
        String key = name.toLowerCase();
        if (this.profiles.containsKey(key)) {
            if (complete != null) {
                complete.accept(this.profiles.get(key));
            }
            return;
        }
        this.profiles.put(key, Optional.empty());
        this.workThread.execute(() -> moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.SkullBlockEntity.ABI.loadCustomProfile(SkullBlockEntity.class, new GameProfile(PlayerTextureDescriptor.NIL_UUID, name), resolvedProfile -> {
            if (resolvedProfile.isPresent()) {
                this.profiles.put(name, (Optional<GameProfile>)resolvedProfile);
            } else {
                this.profiles.remove(name);
            }
            if (complete != null) {
                complete.accept((Optional<GameProfile>)resolvedProfile);
            }
        }));
    }

    public void loadDefaultTexture(ResourceLocation location) {
        boolean alex = location.equals((Object)ALEX_SKIN_LOCATION);
        if (!alex && !location.equals((Object)STEVE_SKIN_LOCATION)) {
            return;
        }
        this.bakedTextures.put(location, Optional.empty());
        this.workThread.execute(() -> {
            PlayerTexture resolvedTexture = new PlayerTexture("", location, null);
            resolvedTexture.setTexture(new BakedEntityTexture(location, alex));
            this.bakedTextures.put(location, Optional.of(resolvedTexture));
        });
    }

    private void loadCustomTextureWithName(String name, Consumer<Optional<PlayerTextureDescriptor>> complete) {
        this.loadGameProfileWithName(name, resolvedProfile -> {
            if (resolvedProfile.isPresent()) {
                this.loadCustomTextureWithProfile((GameProfile)resolvedProfile.get(), complete);
            } else {
                complete.accept(Optional.empty());
            }
        });
    }

    private void loadCustomTextureWithProfile(GameProfile profile, Consumer<Optional<PlayerTextureDescriptor>> complete) {
        PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.fromProfile(profile);
        Optional<PlayerTexture> texture = this.resolvedTextures.get(descriptor);
        if (texture != null) {
            complete.accept(Optional.of(descriptor));
            return;
        }
        ModLog.debug("load player texture => {}", profile);
        SkinManager manager = Minecraft.m_91087_().m_91109_();
        moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.SkinManager.ABI.loadCustomSkin(manager, profile, skin -> {
            String url = skin.textureUrl();
            String model = skin.model().id();
            ResourceLocation location = skin.texture();
            ModLog.debug("receive player texture from vanilla loader => {}", location);
            this.receivePlayerTexture(descriptor, location, url, model);
            complete.accept(Optional.of(descriptor));
        });
    }

    private void loadCustomTextureWithURL(String url, Consumer<Optional<PlayerTextureDescriptor>> complete) {
        PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.fromURL(url);
        Optional<PlayerTexture> texture = this.resolvedTextures.get(descriptor);
        if (texture != null) {
            complete.accept(Optional.of(descriptor));
            return;
        }
        ModLog.debug("load player texture => {}", url);
        String identifier = Hashing.sha1().hashUnencodedChars((CharSequence)url).toString();
        ResourceLocation location = new ResourceLocation("skins/aw-" + identifier);
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        AbstractTexture processingTexture = textureManager.m_174786_(location, null);
        if (processingTexture != null) {
            complete.accept(Optional.of(descriptor));
            return;
        }
        String sub = identifier.length() > 2 ? identifier.substring(0, 2) : "xx";
        File path = new File(String.valueOf(EnvironmentManager.getRootDirectory()) + "/skin-textures/" + sub + "/" + identifier);
        HttpTexture downloadingTexture = new HttpTexture(path, url, ModTextures.MANNEQUIN_DEFAULT, true, () -> {
            ModLog.debug("receive player texture from custom loader => {}", location);
            this.receivePlayerTexture(descriptor, location, url, null);
            complete.accept(Optional.of(descriptor));
        });
        textureManager.m_118495_(location, (AbstractTexture)downloadingTexture);
    }

    public void receivePlayerTexture(String url, NativeImage image, boolean slim) {
        if (image == null) {
            return;
        }
        NativeImage newImage = new NativeImage(image.m_85102_(), image.m_84982_(), image.m_85084_(), true);
        newImage.m_85054_(image);
        this.workThread.execute(() -> {
            BakedEntityTexture bakedTexture = this.getDownloadedTexture(url);
            if (bakedTexture.getModel() == null) {
                bakedTexture.setModel("default");
                if (slim) {
                    bakedTexture.setModel("slim");
                }
            }
            bakedTexture.loadImage(newImage, Objects.equals(bakedTexture.getModel(), "slim"));
            ModLog.debug("baked a player texture => {}, url: {}, slim: {}", bakedTexture.getResourceLocation(), url, slim);
        });
    }

    private synchronized void receivePlayerTexture(PlayerTextureDescriptor descriptor, ResourceLocation location, String url, String model) {
        PlayerTexture resolvedTexture = new PlayerTexture(url, location, model);
        BakedEntityTexture bakedTexture = this.getDownloadedTexture(url);
        bakedTexture.setResourceLocation(location);
        bakedTexture.setModel(model);
        resolvedTexture.setTexture(bakedTexture);
        this.resolvedTextures.put(descriptor, Optional.of(resolvedTexture));
        this.bakedTextures.put(location, Optional.of(resolvedTexture));
        this.loadingTextures.remove(descriptor);
    }

    private synchronized BakedEntityTexture getDownloadedTexture(String url) {
        return this.downloadedTextures.computeIfAbsent(url, k -> new BakedEntityTexture());
    }
}

