/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PlayerTextureDescriptor {
    public static final PlayerTextureDescriptor EMPTY = new PlayerTextureDescriptor(Source.NONE, null, null);
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    private static final Cache<ItemStack, PlayerTextureDescriptor> DESCRIPTOR_CACHES = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(15L, TimeUnit.SECONDS).build();
    private Source source;
    private String value;
    private GameProfile profile;

    public PlayerTextureDescriptor(Source source, String value, GameProfile profile) {
        this.source = source;
        this.value = value;
        this.profile = profile;
    }

    public PlayerTextureDescriptor(@Nullable CompoundTag nbt) {
        CompoundTag tag;
        if (nbt != null && nbt.m_128425_("URL", 8)) {
            this.source = Source.URL;
            this.value = nbt.m_128461_("URL");
        }
        if (nbt != null && nbt.m_128425_("User", 10) && (tag = nbt.m_128469_("User")).m_128425_("Name", 8)) {
            this.source = Source.USER;
            this.value = tag.m_128461_("Name");
        }
        if (this.value == null && this.profile == null) {
            this.source = Source.NONE;
        }
    }

    public static PlayerTextureDescriptor of(ItemStack itemStack) {
        if (!itemStack.m_150930_((Item)ModItems.MANNEQUIN.get())) {
            return EMPTY;
        }
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag == null || !entityTag.m_128425_("Texture", 10)) {
            return EMPTY;
        }
        PlayerTextureDescriptor descriptor = (PlayerTextureDescriptor)DESCRIPTOR_CACHES.getIfPresent((Object)itemStack);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new PlayerTextureDescriptor(entityTag.m_128469_("Texture"));
        DESCRIPTOR_CACHES.put((Object)itemStack, (Object)descriptor);
        return descriptor;
    }

    public static PlayerTextureDescriptor fromURL(String url) {
        return new PlayerTextureDescriptor(Source.URL, url, null);
    }

    public static PlayerTextureDescriptor fromName(String name) {
        return new PlayerTextureDescriptor(Source.USER, name, null);
    }

    public static PlayerTextureDescriptor fromProfile(GameProfile profile) {
        return new PlayerTextureDescriptor(Source.USER, profile.getName(), profile);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        switch (this.source.ordinal()) {
            case 2: {
                if (this.value == null) break;
                nbt.m_128359_("URL", this.value);
                break;
            }
            case 1: {
                if (this.value == null) break;
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Name", this.value);
                nbt.m_128365_("User", (Tag)tag);
                break;
            }
        }
        return nbt;
    }

    public boolean isEmpty() {
        return this.source == Source.NONE;
    }

    @Nullable
    public String getURL() {
        if (this.source == Source.URL) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public String getName() {
        if (this.source == Source.USER && this.value != null) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public String getValue() {
        return this.value;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerTextureDescriptor that = (PlayerTextureDescriptor)o;
        return this.source == that.source && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.value});
    }

    public static enum Source {
        NONE,
        USER,
        URL;

    }
}

