/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.blockbench;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchFace;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchObject;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.core.Direction;

public class BlockBenchElement
extends BlockBenchObject {
    private final String type;
    private final boolean boxUV;
    private final boolean allowMirrorModeling;
    private final boolean allowExport;
    private final Vector2f uvOffset;
    private final Vector3f from;
    private final Vector3f to;
    private final Vector3f origin;
    private final Vector3f rotation;
    private final float inflate;
    private final Map<Direction, BlockBenchFace> faces;

    public BlockBenchElement(String uuid, String name, String type, boolean boxUV, boolean allowMirrorModeling, boolean allowExport, Vector2f uvOffset, Vector3f from, Vector3f to, Vector3f origin, Vector3f rotation, float inflate, Map<Direction, BlockBenchFace> faces) {
        super(uuid, name);
        this.type = type;
        this.boxUV = boxUV;
        this.allowMirrorModeling = allowMirrorModeling;
        this.allowExport = allowExport;
        this.uvOffset = uvOffset;
        this.from = from;
        this.to = to;
        this.origin = origin;
        this.rotation = rotation;
        this.inflate = inflate;
        this.faces = faces;
    }

    public String getType() {
        return this.type;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public float getInflate() {
        return this.inflate;
    }

    public boolean isBoxUV() {
        return this.boxUV;
    }

    public boolean allowExport() {
        return this.allowExport;
    }

    public Vector2f getUVOffset() {
        return this.uvOffset;
    }

    public Map<Direction, BlockBenchFace> getFaces() {
        return this.faces;
    }

    public static class Builder
    extends BlockBenchObject.Builder {
        private String type = "cube";
        private boolean boxUV = false;
        private boolean allowMirrorModeling = false;
        private boolean allowExport = true;
        private Vector2f uvOffset = Vector2f.ZERO;
        private Vector3f from = Vector3f.ZERO;
        private Vector3f to = Vector3f.ZERO;
        private Vector3f origin = Vector3f.ZERO;
        private Vector3f rotation = Vector3f.ZERO;
        private float inflate = 0.0f;
        private HashMap<Direction, BlockBenchFace> faces = new HashMap();

        public void type(String type) {
            this.type = type;
        }

        public void boxUV(boolean boxUV) {
            this.boxUV = boxUV;
        }

        public void allowMirrorModeling(boolean allowMirrorModeling) {
            this.allowMirrorModeling = allowMirrorModeling;
        }

        public void from(Vector3f from) {
            this.from = from;
        }

        public void to(Vector3f to) {
            this.to = to;
        }

        public void origin(Vector3f origin) {
            this.origin = origin;
        }

        public void rotation(Vector3f rotation) {
            this.rotation = rotation;
        }

        public void inflate(float inflate) {
            this.inflate = inflate;
        }

        public void uvOffset(Vector2f uvOffset) {
            this.uvOffset = uvOffset;
        }

        public void export(boolean allowExport) {
            this.allowExport = allowExport;
        }

        public void addFace(Direction dir, BlockBenchFace face) {
            this.faces.put(dir, face);
        }

        public BlockBenchElement build() {
            return new BlockBenchElement(this.uuid, this.name, this.type, this.boxUV, this.allowMirrorModeling, this.allowExport, this.uvOffset, this.from, this.to, this.origin, this.rotation, this.inflate, this.faces);
        }
    }
}

