/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import java.util.EnumMap;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class BedrockModelUV {
    public static final BedrockModelUV EMPTY = new BedrockModelUV();
    private final Vector2f base;
    private EnumMap<Direction, Integer> rotations;
    private final EnumMap<Direction, Rectangle2f> rects = new EnumMap(Direction.class);

    public BedrockModelUV() {
        this.base = null;
    }

    public BedrockModelUV(Vector2f uv) {
        this.base = uv;
    }

    public void forEach(BiConsumer<Direction, Rectangle2f> consumer) {
        if (this.base == null) {
            this.rects.forEach(consumer);
        }
    }

    public void forEachRotations(BiConsumer<Direction, Integer> consumer) {
        if (this.rotations != null) {
            this.rotations.forEach(consumer);
        }
    }

    public void put(Direction dir, Rectangle2f rect) {
        this.rects.put(dir, rect);
    }

    public void setRotation(Direction dir, int rotation) {
        if (rotation == 0) {
            return;
        }
        if (this.rotations == null) {
            this.rotations = new EnumMap(Direction.class);
        }
        this.rotations.put(dir, rotation);
    }

    public int getRotation(Direction dir) {
        if (this.rotations != null) {
            return this.rotations.getOrDefault(dir, 0);
        }
        return 0;
    }

    public Vector2f getBase() {
        return this.base;
    }

    @Nullable
    public Rectangle2f getRect(Direction dir) {
        return this.rects.get(dir);
    }
}

