/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class BedrockModelBone {
    private final String name;
    private final String parent;
    private final Vector3f pivot;
    private final Vector3f rotation;
    private final boolean mirror;
    private final Collection<BedrockModelCube> cubes;
    private final Map<String, Vector3f> locators;

    public BedrockModelBone(String name, String parent, Vector3f pivot, Vector3f rotation, boolean mirror, Collection<BedrockModelCube> cubes, Map<String, Vector3f> locators) {
        this.name = name;
        this.parent = parent;
        this.pivot = pivot;
        this.rotation = rotation;
        this.mirror = mirror;
        this.cubes = cubes;
        this.locators = locators;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public Collection<BedrockModelCube> getCubes() {
        return this.cubes;
    }

    public Map<String, Vector3f> getLocators() {
        return this.locators;
    }

    public static class Builder {
        private String name;
        private String parent = "";
        private Vector3f pivot = Vector3f.ZERO;
        private Vector3f rotation = Vector3f.ZERO;
        private boolean mirror = false;
        private final ArrayList<BedrockModelCube> cubes = new ArrayList();
        private final HashMap<String, Vector3f> locators = new HashMap();

        public void name(String name) {
            this.name = name;
        }

        public void parent(String parent) {
            this.parent = parent;
        }

        public void pivot(Vector3f pivot) {
            this.pivot = pivot;
        }

        public void rotation(Vector3f rotation) {
            this.rotation = rotation;
        }

        public void mirror(boolean mirror) {
            this.mirror = mirror;
        }

        public void addCube(BedrockModelCube cube) {
            this.cubes.add(cube);
        }

        public void addLocator(String name, Vector3f locator) {
            this.locators.put(name, locator);
        }

        public BedrockModelBone build() {
            return new BedrockModelBone(this.name, this.parent, this.pivot, this.rotation, this.mirror, this.cubes, this.locators);
        }
    }
}

