/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.v2;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.api.skin.ISkinCube;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer2;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeEncoder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.texture.TextureBox;
import moe.plushie.armourers_workshop.utils.texture.TextureOptions;
import net.minecraft.core.Direction;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkCubeEncoderV2
extends ChunkCubeEncoder {
    private ISkinCube cube;
    private final SortedMap<Vector2f> startValues = new SortedMap();
    private final SortedMap<Vector2f> endValues = new SortedMap();
    private final SortedMap<TextureOptions> optionsValues = new SortedMap();

    @Override
    public int begin(ISkinCube cube) {
        for (Direction dir : Direction.values()) {
            ITextureKey value = cube.getTexture(dir);
            if (value == null) continue;
            ITextureProvider provider = value.getProvider();
            TextureBox.Entry entry = ObjectUtils.safeCast(value, TextureBox.Entry.class);
            if (entry != null) {
                this.startValues.put(128, entry.getParent(), provider);
                continue;
            }
            int face = 1 << dir.m_122411_();
            float u = value.getU();
            float v = value.getV();
            float s = value.getWidth();
            float t = value.getHeight();
            this.startValues.put(face, new Vector2f(u, v), provider);
            this.endValues.put(face, new Vector2f(u + s, v + t), provider);
            if (!(value.getOptions() instanceof TextureOptions)) continue;
            this.optionsValues.put(face, (TextureOptions)value.getOptions(), provider);
        }
        this.cube = cube;
        return this.startValues.size() + this.endValues.size() + this.optionsValues.size();
    }

    @Override
    public void end(ChunkPaletteData palette, ChunkOutputStream stream) throws IOException {
        stream.writeRectangle3f(this.cube.getShape());
        stream.writeTransformf(this.cube.getTransform());
        this.optionsValues.forEach((key, value) -> {
            stream.writeByte(0x40 | value);
            stream.writeVariable(palette.writeTextureOptions((TextureOptions)key.getLeft(), (ITextureProvider)key.getRight()));
        });
        this.startValues.forEach((key, value) -> {
            stream.writeByte((int)value);
            stream.writeVariable(palette.writeTexture((Vector2f)key.getLeft(), (ITextureProvider)key.getRight()));
        });
        this.endValues.forEach((key, value) -> {
            stream.writeByte((int)value);
            stream.writeVariable(palette.writeTexture((Vector2f)key.getLeft(), (ITextureProvider)key.getRight()));
        });
        this.startValues.clear();
        this.endValues.clear();
        this.optionsValues.clear();
        this.cube = null;
    }

    public static class SortedMap<T> {
        private final LinkedHashMap<Pair<T, ITextureProvider>, Integer> impl = new LinkedHashMap();

        public void forEach(IOConsumer2<Pair<T, ITextureProvider>, Integer> consumer) throws IOException {
            for (Map.Entry<Pair<T, ITextureProvider>, Integer> entry : this.impl.entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }

        public void put(int face, T pos, ITextureProvider provider) {
            Pair index = Pair.of(pos, (Object)provider);
            int newFace = this.impl.getOrDefault(index, 0);
            this.impl.put(index, newFace |= face);
        }

        public void clear() {
            this.impl.clear();
        }

        public int size() {
            return this.impl.size();
        }
    }
}

