/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder;

import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public abstract class ChunkCubeDecoder
extends ChunkCubeSlice {
    protected final int faceCount;
    protected final byte[] bytes;
    protected final ChunkPaletteData palette;

    public ChunkCubeDecoder(int startIndex, int endIndex, ChunkCubeSelector selector, ChunkCubeSection.Immutable section) {
        super(startIndex, endIndex, selector.index, section);
        this.bytes = section.getBytes();
        this.palette = section.getPalette();
        this.faceCount = section.getCubeOptions() & 0xF;
    }

    protected byte getByte(int offset) {
        return this.bytes[this.readerIndex + offset];
    }

    protected int getInt(int offset) {
        int ch1 = this.getByte(offset) & 0xFF;
        int ch2 = this.getByte(offset + 1) & 0xFF;
        int ch3 = this.getByte(offset + 2) & 0xFF;
        int ch4 = this.getByte(offset + 3) & 0xFF;
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    protected float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    protected Vector3f getVector3f(int offset) {
        float x = this.getFloat(offset);
        float y = this.getFloat(offset + 4);
        float z = this.getFloat(offset + 8);
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return Vector3f.ZERO;
        }
        if (x == 1.0f && y == 1.0f && z == 1.0f) {
            return Vector3f.ONE;
        }
        return new Vector3f(x, y, z);
    }
}

