/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import java.io.IOException;
import java.util.Collection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkType;

public abstract class ChunkSerializer<V, T> {
    private final ChunkType chunkType;

    public ChunkSerializer(ChunkType chunkType) {
        this.chunkType = chunkType;
    }

    public abstract V read(ChunkInputStream var1, String var2, T var3) throws IOException;

    public abstract void write(V var1, T var2, ChunkOutputStream var3) throws IOException;

    public void config(ChunkFlags flags, V value, ChunkContext context) {
    }

    public boolean canRead(String name) {
        return this.chunkType.getName().equals(name);
    }

    public boolean canWrite(V value, T obj, ChunkOutputStream stream) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return true;
    }

    public V getDefaultValue() throws IOException {
        return null;
    }

    public ChunkFlags getChunkFlags(V value, ChunkContext context) {
        ChunkFlags flags = new ChunkFlags();
        this.config(flags, value, context);
        return flags;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }
}

