/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimation;
import moe.plushie.armourers_workshop.utils.texture.TextureProperties;
import net.minecraft.nbt.CompoundTag;

public interface IInputStream {
    public static IInputStream of(DataInputStream stream) {
        return () -> stream;
    }

    public DataInputStream getInputStream();

    default public void read(byte[] b) throws IOException {
        this.getInputStream().readFully(b);
    }

    default public void read(byte[] b, int off, int len) throws IOException {
        this.getInputStream().readFully(b, off, len);
    }

    default public void read(FloatBuffer buffer) throws IOException {
        DataInputStream stream = this.getInputStream();
        int position = buffer.position();
        int limit = buffer.limit();
        for (int index = position; index < limit; ++index) {
            buffer.put(index, stream.readFloat());
        }
    }

    default public ByteBuf readBytes(int limit) throws IOException {
        byte[] bytes;
        DataInputStream inputStream = this.getInputStream();
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        for (int remaining = limit; remaining > 0; remaining -= bytes.length) {
            bytes = new byte[Math.min(remaining, 16384)];
            inputStream.readFully(bytes);
            buffers.add(bytes);
        }
        return Unpooled.wrappedBuffer((byte[][])((byte[][])buffers.toArray((T[])new byte[0][])));
    }

    default public byte readByte() throws IOException {
        return this.getInputStream().readByte();
    }

    default public boolean readBoolean() throws IOException {
        return this.getInputStream().readBoolean();
    }

    default public short readShort() throws IOException {
        return this.getInputStream().readShort();
    }

    default public int readInt() throws IOException {
        return this.getInputStream().readInt();
    }

    default public long readLong() throws IOException {
        return this.getInputStream().readLong();
    }

    default public float readFloat() throws IOException {
        return this.getInputStream().readFloat();
    }

    default public double readDouble() throws IOException {
        return this.getInputStream().readDouble();
    }

    default public String readString() throws IOException {
        int size = this.getInputStream().readUnsignedShort();
        return this.readString(size);
    }

    default public String readString(int len) throws IOException {
        if (len <= 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        this.getInputStream().readFully(bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    default public int readVarInt() throws IOException {
        byte b;
        DataInputStream inputStream = this.getInputStream();
        int i = 0;
        int j = 0;
        do {
            b = inputStream.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) != 0);
        return i;
    }

    default public Vector3i readVector3i() throws IOException {
        DataInputStream stream = this.getInputStream();
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        return new Vector3i(x, y, z);
    }

    default public Vector3f readVector3f() throws IOException {
        DataInputStream stream = this.getInputStream();
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        return new Vector3f(x, y, z);
    }

    default public Rectangle3i readRectangle3i() throws IOException {
        DataInputStream stream = this.getInputStream();
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        int width = stream.readInt();
        int height = stream.readInt();
        int depth = stream.readInt();
        return new Rectangle3i(x, y, z, width, height, depth);
    }

    default public Rectangle3f readRectangle3f() throws IOException {
        DataInputStream stream = this.getInputStream();
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        float width = stream.readFloat();
        float height = stream.readFloat();
        float depth = stream.readFloat();
        return new Rectangle3f(x, y, z, width, height, depth);
    }

    default public SkinTransform readTransformf() throws IOException {
        SkinTransform transform = new SkinTransform();
        transform.readFromStream(this);
        if (!transform.equals(SkinTransform.IDENTITY)) {
            return transform;
        }
        return SkinTransform.IDENTITY;
    }

    default public <T extends IRegistryEntry> T readType(Function<String, T> transform) throws IOException {
        String name = this.readString();
        return (T)((IRegistryEntry)transform.apply(name));
    }

    default public SkinProperties readSkinProperties() throws IOException {
        SkinProperties properties = new SkinProperties();
        properties.readFromStream(this);
        return properties;
    }

    default public TextureAnimation readTextureAnimation() throws IOException {
        TextureAnimation animation = new TextureAnimation();
        animation.readFromStream(this);
        return animation;
    }

    default public TextureProperties readTextureProperties() throws IOException {
        TextureProperties properties = new TextureProperties();
        properties.readFromStream(this);
        return properties;
    }

    default public CompoundTag readCompoundTag() throws IOException {
        return SkinFileUtils.readNBT(this.getInputStream());
    }
}

