/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class SkinSettings {
    private int dataVersion = 1;
    private boolean isPreviewMode = false;
    private boolean isEditable = true;
    private List<Rectangle3i> collisionBox;
    private SkinItemTransforms itemTransforms;

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeVarInt(this.dataVersion);
        this.writeItemTransform(stream);
        this.writeCollisionBox(stream);
        stream.writeBoolean(this.isEditable);
    }

    public void readFromStream(IInputStream stream) throws IOException {
        this.dataVersion = stream.readVarInt();
        this.readItemTransforms(stream);
        this.readCollisionBox(stream);
        this.isEditable = stream.readBoolean();
    }

    public void readFromLegacyStream(IInputStream stream) throws IOException {
        this.readItemTransforms(stream);
        this.isEditable = stream.readBoolean();
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
    }

    public boolean isPreviewMode() {
        return this.isPreviewMode;
    }

    public void setItemTransforms(SkinItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
    }

    public SkinItemTransforms getItemTransforms() {
        return this.itemTransforms;
    }

    public void setCollisionBox(List<Rectangle3i> collisionBox) {
        this.collisionBox = collisionBox;
    }

    public List<Rectangle3i> getCollisionBox() {
        return this.collisionBox;
    }

    public boolean isEmpty() {
        return this.isEditable && this.itemTransforms == null;
    }

    public SkinSettings copy() {
        SkinSettings settings = new SkinSettings();
        settings.isEditable = this.isEditable;
        settings.isPreviewMode = this.isPreviewMode;
        settings.itemTransforms = this.itemTransforms;
        return settings;
    }

    private void writeItemTransform(IOutputStream stream) throws IOException {
        if (this.itemTransforms != null) {
            stream.writeVarInt(this.itemTransforms.size() + 1);
            for (Map.Entry entry : this.itemTransforms.entrySet()) {
                ITransformf transform = (ITransformf)entry.getValue();
                stream.writeString((String)entry.getKey());
                stream.writeVector3f(transform.getTranslate());
                stream.writeVector3f(transform.getRotation());
                stream.writeVector3f(transform.getScale());
            }
        } else {
            stream.writeVarInt(0);
        }
    }

    private void readItemTransforms(IInputStream stream) throws IOException {
        int size = stream.readVarInt();
        if (size != 0) {
            this.itemTransforms = new SkinItemTransforms();
            for (int i = 1; i < size; ++i) {
                String name = stream.readString();
                Vector3f translate = stream.readVector3f();
                Vector3f rotation = stream.readVector3f();
                Vector3f scale = stream.readVector3f();
                this.itemTransforms.put(name, SkinTransform.create(translate, rotation, scale));
            }
        } else {
            this.itemTransforms = null;
        }
    }

    private void writeCollisionBox(IOutputStream stream) throws IOException {
        if (this.collisionBox != null) {
            stream.writeVarInt(this.collisionBox.size() + 1);
            for (Rectangle3i box : this.collisionBox) {
                stream.writeRectangle3i(box);
            }
        } else {
            stream.writeVarInt(0);
        }
    }

    private void readCollisionBox(IInputStream stream) throws IOException {
        int size = stream.readVarInt();
        if (size != 0) {
            this.collisionBox = new ArrayList<Rectangle3i>();
            for (int i = 1; i < size; ++i) {
                this.collisionBox.add(stream.readRectangle3i());
            }
        } else {
            this.collisionBox = null;
        }
    }
}

