/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.LinkedHashMap;
import java.util.Stack;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SkinDocumentSynchronizer
implements SkinDocumentListener {
    private boolean isApplying = false;
    private boolean isCapturing = false;
    private CompoundTag capturedPropertiesValues;
    private CompoundTag capturedSettingValues;
    private final LinkedHashMap<String, CompoundTag> capturedNodeValues = new LinkedHashMap();
    private final Stack<Boolean> capturedStates = new Stack();
    private final BlockEntity blockEntity;

    public SkinDocumentSynchronizer(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public void documentDidChangeType(SkinDocumentType type) {
        this.post(new UpdateSkinDocumentPacket.ChangeTypeAction(type));
    }

    @Override
    public void documentDidChangeSettings(CompoundTag tag) {
        if (this.isCapturing) {
            if (this.capturedSettingValues != null) {
                this.capturedSettingValues.m_128391_(tag);
            } else {
                this.capturedSettingValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateSettingsAction(tag));
    }

    @Override
    public void documentDidChangeProperties(CompoundTag tag) {
        if (this.isCapturing) {
            if (this.capturedPropertiesValues != null) {
                this.capturedPropertiesValues.m_128391_(tag);
            } else {
                this.capturedPropertiesValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdatePropertiesAction(tag));
    }

    @Override
    public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.InsertNodeAction(node.getId(), index, target.serializeNBT()));
    }

    @Override
    public void documentDidUpdateNode(SkinDocumentNode node, CompoundTag tag) {
        if (this.isCapturing) {
            this.capturedNodeValues.computeIfAbsent(node.getId(), it -> tag).m_128391_(tag);
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateNodeAction(node.getId(), tag));
    }

    @Override
    public void documentDidRemoveNode(SkinDocumentNode node) {
        this.post(new UpdateSkinDocumentPacket.RemoveNodeAction(node.getId()));
    }

    @Override
    public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.MoveNodeAction(node.getId(), target.getId(), index));
    }

    @Override
    public void documentWillBeginEditing() {
        this.isApplying = true;
    }

    @Override
    public void documentDidEndEditing() {
        this.isApplying = false;
    }

    public void beginCapture() {
        this.capturedStates.push(this.isCapturing);
        this.isCapturing = true;
    }

    public void endCapture() {
        this.isCapturing = this.capturedStates.pop();
        if (this.isCapturing) {
            return;
        }
        if (this.capturedPropertiesValues != null) {
            this.documentDidChangeProperties(this.capturedPropertiesValues);
            this.capturedPropertiesValues = null;
        }
        if (this.capturedSettingValues != null) {
            this.documentDidChangeSettings(this.capturedSettingValues);
            this.capturedSettingValues = null;
        }
        this.capturedNodeValues.forEach((id, tag) -> this.post(new UpdateSkinDocumentPacket.UpdateNodeAction((String)id, (CompoundTag)tag)));
        this.capturedNodeValues.clear();
    }

    private void post(UpdateSkinDocumentPacket.Action action) {
        if (this.isApplying) {
            return;
        }
        NetworkManager.sendToServer(new UpdateSkinDocumentPacket(this.blockEntity, action));
    }
}

