/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import net.minecraft.nbt.CompoundTag;

public class SkinDocumentSettings {
    private float scale = 1.0f;
    private boolean showsOrigin = true;
    private boolean showsHelperModel = true;
    private SkinItemTransforms itemTransforms;
    private SkinDocumentListener listener;

    public SkinDocumentSettings() {
    }

    public SkinDocumentSettings(CompoundTag tag) {
        this.scale = OptionalAPI.getOptionalFloat(tag, "Scale", 1.0f);
        this.showsHelperModel = OptionalAPI.getOptionalBoolean(tag, "HelperModel", true);
        this.showsOrigin = OptionalAPI.getOptionalBoolean(tag, "Origin", true);
        this.itemTransforms = OptionalAPI.getOptionalItemTransforms(tag, "ItemTransforms", null);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        OptionalAPI.putOptionalFloat(tag, "Scale", this.scale, 1.0f);
        OptionalAPI.putOptionalBoolean(tag, "HelperModel", this.showsHelperModel, true);
        OptionalAPI.putOptionalBoolean(tag, "Origin", this.showsOrigin, true);
        OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", this.itemTransforms, null);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("Scale")) {
            this.scale = tag.m_128457_("Scale");
        }
        if (tag.m_128441_("HelperModel")) {
            this.showsHelperModel = tag.m_128471_("HelperModel");
        }
        if (tag.m_128441_("Origin")) {
            this.showsHelperModel = tag.m_128471_("Origin");
        }
        if (tag.m_128441_("ItemTransforms")) {
            this.itemTransforms = OptionalAPI.getOptionalItemTransforms(tag, "ItemTransforms", null);
        }
    }

    public void setShowsHelperModel(boolean value) {
        this.showsHelperModel = value;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("HelperModel", value);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public boolean showsHelperModel() {
        return this.showsHelperModel;
    }

    public void setShowsOrigin(boolean value) {
        this.showsOrigin = value;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Origin", value);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public boolean showsOrigin() {
        return this.showsOrigin;
    }

    public void setItemTransforms(SkinItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", itemTransforms, null);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public SkinItemTransforms getItemTransforms() {
        return this.itemTransforms;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
    }

    public static class Keys {
        public static final String SCALE = "Scale";
        public static final String ORIGIN = "Origin";
        public static final String HELPER_MODEL = "HelperModel";
        public static final String ITEM_TRANSFORMS = "ItemTransforms";
    }
}

