/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class SkinDocument {
    private static final DataSerializerKey<SkinDocumentType> TYPE_KEY = DataSerializerKey.create("Type", DataTypeCodecs.SKIN_DOCUMENT_TYPE, SkinDocumentTypes.GENERAL_ARMOR_HEAD);
    private static final DataSerializerKey<SkinDocumentNode> NODES_KEY = DataSerializerKey.create("Nodes", DataTypeCodecs.SKIN_DOCUMENT_NODE, null);
    private static final DataSerializerKey<SkinDocumentSettings> SETTINGS_KEY = DataSerializerKey.create("Settings", DataTypeCodecs.SKIN_DOCUMENT_SETTINGS, null, SkinDocumentSettings::new);
    private static final DataSerializerKey<SkinProperties> PROPERTIES_KEY = DataSerializerKey.create("Properties", DataTypeCodecs.SKIN_PROPERTIES, SkinProperties.EMPTY, SkinProperties::new);
    private SkinDocumentType type;
    private SkinDocumentNode nodes;
    private SkinProperties properties = new SkinProperties();
    private SkinDocumentSettings settings = new SkinDocumentSettings();
    private final SkinDocumentListeners.Proxy listener = new SkinDocumentListeners.Proxy();

    public SkinDocument() {
        this.setType(SkinDocumentTypes.GENERAL_ARMOR_HEAD);
    }

    public void reset() {
        this.setType(this.type);
    }

    public void setType(SkinDocumentType type) {
        this.type = type;
        this.nodes = this._generateDefaultNode(type);
        this.settings = this._generateSkinSettings();
        this.properties = this._generateSkinProperties();
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidChangeType(type);
    }

    public void serialize(IDataSerializer serializer) {
        serializer.write(TYPE_KEY, this.type);
        serializer.write(NODES_KEY, this.nodes);
        serializer.write(SETTINGS_KEY, this.settings);
        serializer.write(PROPERTIES_KEY, this.properties);
    }

    public void deserialize(IDataSerializer serializer) {
        this.type = serializer.read(TYPE_KEY);
        this.settings = serializer.read(SETTINGS_KEY);
        this.properties = serializer.read(PROPERTIES_KEY);
        this.nodes = serializer.read(NODES_KEY);
        if (this.nodes == null) {
            this.nodes = this._generateDefaultNode(this.type);
        }
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidReload();
    }

    public void updateSettings(CompoundTag tag) {
        this.settings.deserializeNBT(tag);
        this.listener.documentDidChangeSettings(tag);
    }

    public void updateProperties(CompoundTag value) {
        this.properties.putAll(new SkinProperties.Changes(value));
        this.listener.documentDidChangeProperties(value);
    }

    public <T> void put(ISkinProperty<T> property, T value) {
        this.properties.put(property, value);
        SkinProperties.Changes changes = new SkinProperties.Changes();
        changes.put(property, value);
        this.listener.documentDidChangeProperties(changes.serializeNBT());
    }

    public <T> T get(ISkinProperty<T> property) {
        return this.properties.get(property);
    }

    public void beginEditing() {
        this.listener.documentWillBeginEditing();
    }

    public void endEditing() {
        this.listener.documentDidEndEditing();
    }

    public void addListener(SkinDocumentListener listener) {
        this.listener.addListener(listener);
    }

    public void removeListener(SkinDocumentListener listener) {
        this.listener.removeListener(listener);
    }

    public void setItemTransforms(SkinItemTransforms itemTransforms) {
        this.settings.setItemTransforms(itemTransforms);
    }

    public SkinItemTransforms getItemTransforms() {
        return this.settings.getItemTransforms();
    }

    public SkinDocumentListener getHandler() {
        return this.listener;
    }

    public SkinDocumentNode nodeById(String id) {
        return this._findNodeById(this.nodes, id);
    }

    public SkinDocumentNode getRoot() {
        return this.nodes;
    }

    public SkinDocumentSettings getSettings() {
        return this.settings;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public SkinDocumentType getType() {
        return this.type;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "type", this.type);
    }

    private SkinDocumentNode _findNodeById(SkinDocumentNode parent, String id) {
        if (id.equals(parent.getId())) {
            return parent;
        }
        for (SkinDocumentNode node : parent.children()) {
            SkinDocumentNode result = this._findNodeById(node, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private SkinDocumentSettings _generateSkinSettings() {
        SkinDocumentSettings settings1 = new SkinDocumentSettings();
        settings1.setShowsOrigin(this.settings.showsOrigin());
        settings1.setShowsHelperModel(this.settings.showsHelperModel());
        return settings1;
    }

    private SkinProperties _generateSkinProperties() {
        String name = this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        SkinProperties properties = new SkinProperties();
        properties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        properties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
        return properties;
    }

    private SkinDocumentNode _generateDefaultNode(SkinDocumentType category) {
        SkinDocumentNode root = new SkinDocumentNode("root", null);
        for (ISkinPartType iSkinPartType : category.getSkinPartTypes()) {
            ResourceLocation registryName = iSkinPartType.getRegistryName();
            SkinDocumentNode node = new SkinDocumentNode(registryName.m_135815_(), null);
            node.setType(iSkinPartType);
            root.add(node);
        }
        root.add(new SkinDocumentNode("float", null));
        root.add(new SkinDocumentNode("static", null));
        return root;
    }
}

