/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.ItemStackStorage;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SkinDescriptor
implements ISkinDescriptor {
    public static final SkinDescriptor EMPTY = new SkinDescriptor("");
    private final String identifier;
    private final ISkinType type;
    private final SkinOptions options;
    private final ColorScheme colorScheme;
    private ItemStack skinItemStack;

    public SkinDescriptor(String identifier) {
        this(identifier, SkinTypes.UNKNOWN, SkinOptions.DEFAULT, ColorScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, ISkinType type) {
        this(identifier, type, SkinOptions.DEFAULT, ColorScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, ISkinType type, ColorScheme colorScheme) {
        this(identifier, type, SkinOptions.DEFAULT, colorScheme);
    }

    public SkinDescriptor(String identifier, ISkinType type, SkinOptions options, ColorScheme colorScheme) {
        this.identifier = identifier;
        this.type = type;
        this.options = options;
        this.colorScheme = colorScheme;
    }

    public SkinDescriptor(SkinDescriptor descriptor, ColorScheme colorScheme) {
        this(descriptor.getIdentifier(), descriptor.getType(), descriptor.getOptions(), colorScheme);
    }

    public SkinDescriptor(CompoundTag tag) {
        this.identifier = tag.m_128461_("Identifier");
        this.type = SkinTypes.byName(tag.m_128461_("SkinType"));
        this.options = OptionalAPI.getOptionalSkinOptions(tag, "SkinOptions", SkinOptions.DEFAULT);
        this.colorScheme = OptionalAPI.getOptionalColorScheme(tag, "SkinDyes", ColorScheme.EMPTY);
    }

    public static SkinDescriptor of(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return EMPTY;
        }
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        SkinDescriptor descriptor = storage.skinDescriptor;
        if (descriptor != null) {
            return descriptor;
        }
        storage.skinDescriptor = descriptor = ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), EMPTY);
        return descriptor;
    }

    public boolean accept(ItemStack itemStack) {
        if (itemStack.m_41619_() || this.isEmpty()) {
            return false;
        }
        ISkinType skinType = this.getType();
        if (skinType == SkinTypes.ITEM) {
            return true;
        }
        if (skinType instanceof ISkinToolType) {
            return ((ISkinToolType)((Object)skinType)).contains(itemStack);
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isEmpty()) {
            return nbt;
        }
        nbt.m_128359_("SkinType", this.type.getRegistryName().toString());
        nbt.m_128359_("Identifier", this.identifier);
        OptionalAPI.putOptionalSkinOptions(nbt, "SkinOptions", this.options, SkinOptions.DEFAULT);
        OptionalAPI.putOptionalColorScheme(nbt, "SkinDyes", this.colorScheme, ColorScheme.EMPTY);
        return nbt;
    }

    public ItemStack sharedItemStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (this.skinItemStack != null) {
            return this.skinItemStack;
        }
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.SKIN.get());
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), this);
        this.skinItemStack = itemStack;
        return itemStack;
    }

    public ItemStack asItemStack() {
        return this.sharedItemStack().m_41777_();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public ISkinType getType() {
        return this.type;
    }

    public SkinOptions getOptions() {
        return this.options;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return String.format("%s@%s[%s]", this.identifier, this.type.getRegistryName(), this.type.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinDescriptor that = (SkinDescriptor)o;
        return this.identifier.equals(that.identifier) && this.colorScheme.equals(that.colorScheme);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

