/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.permission;

import java.util.Arrays;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.core.permission.BlockPermissionContext;
import moe.plushie.armourers_workshop.core.permission.Permission;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPermission
extends Permission {
    @SafeVarargs
    public BlockPermission(String name, IRegistryKey<Block> ... blocks) {
        super(name);
        Arrays.stream(blocks).forEach(this::add);
    }

    public boolean accept(Player player) {
        if (player == null) {
            return true;
        }
        return this.getNodes().stream().allMatch(node -> this.eval((IPermissionNode)node, player, new PlayerPermissionContext(player)));
    }

    public boolean accept(BlockEntity blockEntity, Player player) {
        BlockState state = blockEntity.m_58900_();
        IPermissionNode node = this.get(TypedRegistry.findKey(state.m_60734_()));
        return this.eval(node, player, new BlockPermissionContext(player, blockEntity.m_58899_(), state, null));
    }
}

