/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractEntityDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class UpdateWardrobePacket
extends CustomPacket {
    private final Type type;
    private final int entityId;
    private final Field field;
    private final Object fieldValue;
    private final CompoundTag compoundTag;

    public UpdateWardrobePacket(IFriendlyByteBuf buffer) {
        this.type = buffer.readEnum(Type.class);
        this.entityId = buffer.readInt();
        if (this.type != Type.SYNC_OPTION) {
            this.fieldValue = null;
            this.field = null;
            this.compoundTag = buffer.readNbt();
        } else {
            this.field = buffer.readEnum(Field.class);
            this.fieldValue = this.field.accessor.read(buffer);
            this.compoundTag = null;
        }
    }

    public UpdateWardrobePacket(SkinWardrobe wardrobe, Type mode, CompoundTag compoundTag, Field field, Object fieldValue) {
        this.type = mode;
        this.entityId = wardrobe.getId();
        this.field = field;
        this.fieldValue = fieldValue;
        this.compoundTag = compoundTag;
    }

    public static UpdateWardrobePacket sync(SkinWardrobe wardrobe) {
        CompoundTag tag = new CompoundTag();
        AbstractDataSerializer serializer = AbstractDataSerializer.wrap(tag, wardrobe.getEntity());
        wardrobe.serialize(serializer);
        return new UpdateWardrobePacket(wardrobe, Type.SYNC, tag, null, null);
    }

    public static UpdateWardrobePacket dying(SkinWardrobe wardrobe, int slot, IPaintColor color) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("Slot", slot);
        OptionalAPI.putOptionalPaintColor(compoundNBT, "Color", color, null);
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_ITEM, compoundNBT, null, null);
    }

    public static UpdateWardrobePacket field(SkinWardrobe wardrobe, Field field, Object value) {
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_OPTION, null, field, value);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.type);
        buffer.writeInt(this.entityId);
        if (this.compoundTag != null) {
            buffer.writeNbt(this.compoundTag);
        }
        if (this.field != null) {
            buffer.writeEnum(this.field);
            this.field.accessor.write(buffer, this.fieldValue);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        String playerName = player.m_5446_().getString();
        if (!(player.f_36096_ instanceof SkinWardrobeMenu)) {
            ModLog.info("reject {} operation for '{}'", this.getOperator(), playerName);
            return;
        }
        if (!this.checkSecurityByServer()) {
            ModLog.info("reject {} operation for '{}', for security reasons.", this.getOperator(), playerName);
            return;
        }
        ModLog.debug("accept {} operation for '{}'", this.getOperator(), playerName);
        SkinWardrobe wardrobe = this.apply((Player)player);
        if (wardrobe != null) {
            NetworkManager.sendToTracking(this, (Entity)player);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        this.apply(player);
    }

    @Nullable
    private SkinWardrobe apply(Player player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(PropertyProvider.getLevel((Entity)player).m_6815_(this.entityId));
        if (wardrobe == null) {
            return null;
        }
        switch (this.type.ordinal()) {
            case 0: {
                wardrobe.deserialize(AbstractDataSerializer.wrap(this.compoundTag, player));
                return wardrobe;
            }
            case 1: {
                Container inventory = wardrobe.getInventory();
                int slot = this.compoundTag.m_128451_("Slot");
                if (slot >= inventory.m_6643_()) break;
                IPaintColor color = OptionalAPI.getOptionalPaintColor(this.compoundTag, "Color", null);
                ItemStack itemStack = ItemStack.f_41583_;
                if (color != null) {
                    itemStack = new ItemStack((ItemLike)ModItems.BOTTLE.get());
                    ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), color);
                }
                inventory.m_6836_(slot, itemStack);
                return wardrobe;
            }
            case 2: {
                if (this.field == null) break;
                this.field.accessor.set(wardrobe, this.fieldValue);
                return wardrobe;
            }
        }
        return null;
    }

    private boolean checkSecurityByServer() {
        switch (this.type.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                int slot = this.compoundTag.m_128451_("Slot");
                int index = slot - SkinSlotType.DYE.getIndex();
                return index >= 8 && index < SkinSlotType.DYE.getMaxSize();
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    private Object getOperator() {
        if (this.field != null) {
            return this.field;
        }
        return this.type;
    }

    public static enum Type {
        SYNC,
        SYNC_ITEM,
        SYNC_OPTION;

    }

    public static enum Field implements DataAccessor.Provider<SkinWardrobe>
    {
        WARDROBE_ARMOUR_HEAD(EquipmentSlot.HEAD),
        WARDROBE_ARMOUR_CHEST(EquipmentSlot.CHEST),
        WARDROBE_ARMOUR_LEGS(EquipmentSlot.LEGS),
        WARDROBE_ARMOUR_FEET(EquipmentSlot.FEET),
        WARDROBE_EXTRA_RENDER(SkinWardrobe::shouldRenderExtra, SkinWardrobe::setRenderExtra),
        MANNEQUIN_IS_CHILD(MannequinEntity.DATA_IS_CHILD),
        MANNEQUIN_IS_FLYING(MannequinEntity.DATA_IS_FLYING),
        MANNEQUIN_IS_VISIBLE(MannequinEntity.DATA_IS_VISIBLE),
        MANNEQUIN_IS_GHOST(MannequinEntity.DATA_IS_GHOST),
        MANNEQUIN_EXTRA_RENDER(MannequinEntity.DATA_EXTRA_RENDERER),
        MANNEQUIN_POSE(MannequinEntity::saveCustomPose, MannequinEntity::readCustomPose, DataSerializers.COMPOUND_TAG),
        MANNEQUIN_POSITION(Entity::m_20182_, Entity::m_20219_, DataSerializers.VECTOR_3D),
        MANNEQUIN_TEXTURE(MannequinEntity.DATA_TEXTURE);

        private final DataAccessor<SkinWardrobe, Object> accessor;

        private Field(EquipmentSlot slotType) {
            this(w -> w.shouldRenderEquipment(slotType), (w, v) -> w.setRenderEquipment(slotType, (boolean)v));
        }

        private Field(Function<SkinWardrobe, Boolean> supplier, BiConsumer<SkinWardrobe, Boolean> applier) {
            this.accessor = DataAccessor.erased(DataSerializers.BOOLEAN, supplier, applier);
        }

        private <S extends Entity, T> Field(Function<S, T> supplier, BiConsumer<S, T> applier, IEntitySerializer<T> dataSerializer) {
            this.accessor = DataAccessor.erased(dataSerializer, wardrobe -> {
                if (wardrobe.getEntity() != null) {
                    return supplier.apply((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()));
                }
                return null;
            }, (wardrobe, value) -> {
                if (wardrobe.getEntity() != null) {
                    applier.accept((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()), value);
                }
            });
        }

        private <T> Field(EntityDataAccessor<T> dataParameter) {
            this(e -> e.m_20088_().m_135370_(dataParameter), (e, v) -> e.m_20088_().m_135381_(dataParameter, v), AbstractEntityDataSerializer.wrap(dataParameter));
        }

        @Override
        public DataAccessor<SkinWardrobe, Object> getAccessor() {
            return this.accessor;
        }
    }
}

