/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateHologramProjectorPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateHologramProjectorPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.field = buffer.readEnum(Field.class);
        this.fieldValue = this.field.accessor.read(buffer);
    }

    public UpdateHologramProjectorPacket(HologramProjectorBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum(this.field);
        this.field.accessor.write(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity entity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (entity instanceof HologramProjectorBlockEntity) {
            this.field.accessor.set((HologramProjectorBlockEntity)entity, this.fieldValue);
        }
    }

    public static enum Field implements DataAccessor.Provider<HologramProjectorBlockEntity>
    {
        POWER_MODE(HologramProjectorBlockEntity::getPowerMode, HologramProjectorBlockEntity::setPowerMode, DataSerializers.INT),
        IS_GLOWING(HologramProjectorBlockEntity::isGlowing, HologramProjectorBlockEntity::setGlowing, DataSerializers.BOOLEAN),
        SHOWS_ROTATION_POINT(HologramProjectorBlockEntity::shouldShowRotationPoint, HologramProjectorBlockEntity::setShowRotationPoint, DataSerializers.BOOLEAN),
        OFFSET(HologramProjectorBlockEntity::getModelOffset, HologramProjectorBlockEntity::setModelOffset, DataSerializers.VECTOR_3F),
        ANGLE(HologramProjectorBlockEntity::getModelAngle, HologramProjectorBlockEntity::setModelAngle, DataSerializers.VECTOR_3F),
        ROTATION_OFFSET(HologramProjectorBlockEntity::getRotationOffset, HologramProjectorBlockEntity::setRotationOffset, DataSerializers.VECTOR_3F),
        ROTATION_SPEED(HologramProjectorBlockEntity::getRotationSpeed, HologramProjectorBlockEntity::setRotationSpeed, DataSerializers.VECTOR_3F);

        private final DataAccessor<HologramProjectorBlockEntity, Object> accessor;

        private <T> Field(Function<HologramProjectorBlockEntity, T> supplier, BiConsumer<HologramProjectorBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            this.accessor = DataAccessor.erased(dataSerializer, supplier, applier);
        }

        @Override
        public DataAccessor<HologramProjectorBlockEntity, Object> getAccessor() {
            return this.accessor;
        }
    }
}

