/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinDyeType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.DyeTableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlot;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DyeTableMenu
extends AbstractBlockEntityMenu<DyeTableBlockEntity> {
    private final ISkinPaintType[] paintTypes = new ISkinPaintType[]{SkinPaintTypes.DYE_1, SkinPaintTypes.DYE_2, SkinPaintTypes.DYE_3, SkinPaintTypes.DYE_4, SkinPaintTypes.DYE_5, SkinPaintTypes.DYE_6, SkinPaintTypes.DYE_7, SkinPaintTypes.DYE_8};
    private final Container inventory;
    private ArrayList<ISkinPaintType> lockedPaintTypes = new ArrayList();

    public DyeTableMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.inventory = ((DyeTableBlockEntity)this.blockEntity).getInventory();
        this.addPlayerSlots((Container)playerInventory, 8, 108);
        this.addCustomSlots(this.inventory, 68, 36, 22, 22);
        this.addInputSlot(this.inventory, 8, 26, 23);
        this.addOutputSlot(this.inventory, 9, 26, 69);
    }

    public void reload(Set<ISkinDyeType> dyeTypes) {
        this.lockedPaintTypes = dyeTypes != null ? ObjectUtils.filter(this.paintTypes, it -> !dyeTypes.contains(it.getDyeType())) : new ArrayList();
    }

    public ItemStack getInputStack() {
        return this.inventory.m_8020_(8);
    }

    public ItemStack getOutputStack() {
        return this.inventory.m_8020_(9);
    }

    public void setOutputStack(ItemStack itemStack) {
        this.inventory.m_6836_(9, itemStack);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size() - 1);
    }

    protected void addInputSlot(final Container inventory, int slot, int x, int y) {
        this.m_38897_(new Slot(inventory, slot, x, y){

            public boolean m_8010_(Player player) {
                return false;
            }

            public boolean m_5857_(ItemStack itemStack) {
                return !SkinDescriptor.of(itemStack).isEmpty();
            }

            public void m_6654_() {
                super.m_6654_();
                if (inventory.m_8020_(9).m_41619_()) {
                    DyeTableMenu.this.loadSkin(this.m_7993_());
                }
            }
        });
    }

    protected void addOutputSlot(Container inventory, int slot, int x, int y) {
        this.m_38897_(new Slot(inventory, slot, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }

            public void m_6654_() {
                super.m_6654_();
                if (!this.m_6657_()) {
                    DyeTableMenu.this.loadSkin(ItemStack.f_41583_);
                }
            }
        });
    }

    protected void addCustomSlots(Container inventory, int x, int y, int itemWidth, int itemHeight) {
        for (int i = 0; i < this.paintTypes.length; ++i) {
            int ix = x + i % 4 * itemWidth;
            int iy = y + i / 4 * itemHeight;
            this.m_38897_(new LockableSlot(inventory, i, ix, iy, this.paintTypes[i]));
        }
    }

    protected void loadSkin(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            this.inventory.m_6211_();
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        ColorScheme scheme = descriptor.getColorScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = ItemStack.f_41583_;
            IPaintColor paintColor = scheme.getColor(this.paintTypes[i]);
            if (paintColor != null) {
                colorStack = new ItemStack((ItemLike)ModItems.BOTTLE.get());
                ColorUtils.setColor(colorStack, paintColor);
            }
            this.inventory.m_6836_(i, colorStack);
        }
        this.setOutputStack(itemStack.m_41777_());
    }

    protected void applySkin(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        ColorScheme newScheme = new ColorScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = this.inventory.m_8020_(i);
            IPaintColor paintColor = ColorUtils.getColor(colorStack);
            if (paintColor == null) continue;
            newScheme.setColor(this.paintTypes[i], paintColor);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (newScheme.equals(descriptor.getColorScheme())) {
            return;
        }
        descriptor = new SkinDescriptor(descriptor, newScheme);
        ItemStack newItemStack = itemStack.m_41777_();
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        this.setOutputStack(newItemStack);
    }

    public class LockableSlot
    extends SkinSlot {
        private final ISkinPaintType paintType;

        public LockableSlot(Container inventory, int slot, int x, int y, ISkinPaintType paintType) {
            super(inventory, slot, x, y, SkinSlotType.DYE);
            this.paintType = paintType;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            if (DyeTableMenu.this.getInputStack().m_41619_()) {
                return false;
            }
            return itemStack.m_41720_() instanceof BottleItem;
        }

        public void m_6654_() {
            super.m_6654_();
            DyeTableMenu.this.applySkin(DyeTableMenu.this.getOutputStack());
        }

        public boolean isLocked() {
            return DyeTableMenu.this.lockedPaintTypes != null && DyeTableMenu.this.lockedPaintTypes.contains(this.paintType);
        }

        public boolean m_6659_() {
            return !this.isLocked();
        }
    }
}

