/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(@Nullable Player player, float scale) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
        CompoundTag entityTag = new CompoundTag();
        if (scale != 1.0f) {
            entityTag.m_128350_("Scale", scale);
        }
        if (player != null) {
            PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.fromProfile(player.m_36316_());
            entityTag.m_128365_("Texture", (Tag)descriptor.serializeNBT());
        }
        if (!entityTag.m_128456_()) {
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
        }
        return itemStack;
    }

    public static boolean isSmall(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            return entityTag.m_128471_("Small");
        }
        return false;
    }

    public static float getScale(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag == null || !entityTag.m_128425_("Scale", 5)) {
            return 1.0f;
        }
        return entityTag.m_128457_("Scale");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        Vector3f origin = new Vector3f((float)player.m_20185_(), (float)player.m_20186_(), (float)player.m_20189_());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.m_43720_(), context.m_8083_());
        ItemStack itemStack = context.m_43722_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverWorld, rayTraceResult.m_82425_(), itemStack, MobSpawnType.SPAWN_EGG);
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            Vec3 clickedLocation = rayTraceResult.m_82450_();
            entity.m_19890_(clickedLocation.m_7096_(), clickedLocation.m_7098_(), clickedLocation.m_7094_(), 0.0f, 0.0f);
            entity.m_5618_(rayTraceResult.getRotation());
            level.m_7967_((Entity)entity);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11684_, SoundSource.BLOCKS, 0.75f, 0.8f);
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    public String m_5671_(ItemStack itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.m_5671_(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.m_5671_(itemStack) + ".big";
        }
        return super.m_5671_(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.of(itemStack);
        if (descriptor.getName() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.getName()));
        }
        if (descriptor.getURL() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.getURL()));
        }
    }
}

