/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;

public class TexturedPaintColor
extends PaintColor {
    private static final Cache<Integer, TexturedPaintColor> POOL = CacheBuilder.newBuilder().maximumSize(2048L).build();

    protected TexturedPaintColor(int value, int rgb, ISkinPaintType paintType) {
        super(value, rgb, paintType);
    }

    public static PaintColor of(int value) {
        if (value == 0) {
            return CLEAR;
        }
        return TexturedPaintColor.of(value, TexturedPaintColor.getPaintType(value));
    }

    public static PaintColor of(int rgb, ISkinPaintType paintType) {
        int value = rgb & 0xFFFFFF | (paintType.getId() & 0xFF) << 24;
        TexturedPaintColor paintColor = (TexturedPaintColor)POOL.getIfPresent((Object)value);
        if (paintColor == null) {
            paintColor = new TexturedPaintColor(value, rgb, paintType);
            POOL.put((Object)value, (Object)paintColor);
        }
        return paintColor;
    }
}

