/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.data.IDataSerializerProvider;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractCapabilityStorage;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityStorage {
    private static final ArrayList<Entry<?>> ENTRIES = new ArrayList();
    private static final CapabilityStorage NONE = new CapabilityStorage(new IdentityHashMap());
    private final IdentityHashMap<ICapabilityType<?>, Pair<Entry<?>, Optional<?>>> capabilities;

    CapabilityStorage(IdentityHashMap<ICapabilityType<?>, Pair<Entry<?>, Optional<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    public static <T> void registerCapability(ResourceLocation registryName, ICapabilityType<T> capabilityType, Function<Entity, Optional<T>> provider) {
        ENTRIES.add(new Entry<T>(registryName, capabilityType, provider));
    }

    public static CapabilityStorage attachCapability(Entity entity) {
        if (ENTRIES.isEmpty()) {
            return NONE;
        }
        IdentityHashMap capabilities = new IdentityHashMap();
        for (Entry<?> entry : ENTRIES) {
            Optional cap = entry.provider.apply(entity);
            if (!cap.isPresent()) continue;
            capabilities.put(entry.capabilityType, Pair.of(entry, cap));
        }
        if (capabilities.isEmpty()) {
            return NONE;
        }
        return new CapabilityStorage(capabilities);
    }

    public static <T> Optional<T> getCapability(Entity entity, ICapabilityType<T> capabilityType) {
        CapabilityStorage storage = ((Provider)entity).getCapabilityStorage();
        Pair<Entry<?>, Optional<?>> value = storage.capabilities.get(capabilityType);
        if (value != null) {
            return (Optional)ObjectUtils.unsafeCast((Optional)value.getValue());
        }
        return Optional.empty();
    }

    public void save(Entity entity, CompoundTag tag) {
        if (this == NONE) {
            return;
        }
        String capsKey = AbstractCapabilityStorage.KEY;
        CompoundTag caps = tag.m_128469_(capsKey);
        this.capabilities.values().forEach(pair -> {
            IDataSerializerProvider provider = ObjectUtils.safeCast(((Optional)pair.getValue()).orElse(null), IDataSerializerProvider.class);
            if (provider != null) {
                CompoundTag tag1 = new CompoundTag();
                provider.serialize(AbstractDataSerializer.wrap(tag1, entity));
                caps.m_128365_(((Entry)pair.getKey()).registryName.toString(), (Tag)tag1);
            }
        });
        if (!caps.m_128456_()) {
            tag.m_128365_(capsKey, (Tag)caps);
        } else {
            tag.m_128473_(capsKey);
        }
    }

    public void load(Entity entity, CompoundTag tag) {
        if (this == NONE) {
            return;
        }
        CompoundTag caps = this.getCapTag(tag);
        if (caps.m_128456_()) {
            return;
        }
        this.capabilities.values().forEach(pair -> {
            CompoundTag tag1;
            IDataSerializerProvider provider = ObjectUtils.safeCast(((Optional)pair.getValue()).orElse(null), IDataSerializerProvider.class);
            if (provider != null && (tag1 = ObjectUtils.safeCast(caps.m_128423_(((Entry)pair.getKey()).registryName.toString()), CompoundTag.class)) != null) {
                provider.deserialize(AbstractDataSerializer.wrap(tag1, entity));
            }
        });
    }

    private CompoundTag getCapTag(CompoundTag tag) {
        if (tag.m_128425_("ForgeCaps", 10)) {
            CompoundTag caps = tag.m_128469_("ForgeCaps");
            if (tag.m_128425_("neoforge:attachments", 10)) {
                caps = caps.m_6426_();
                caps.m_128391_(tag.m_128469_("neoforge:attachments"));
            }
            return caps;
        }
        return tag.m_128469_("neoforge:attachments");
    }

    private static class Entry<T> {
        ResourceLocation registryName;
        ICapabilityType<T> capabilityType;
        Function<Entity, Optional<T>> provider;

        Entry(ResourceLocation registryName, ICapabilityType<T> capabilityType, Function<Entity, Optional<T>> provider) {
            this.registryName = registryName;
            this.capabilityType = capabilityType;
            this.provider = provider;
        }
    }

    public static interface Provider {
        public CapabilityStorage getCapabilityStorage();
    }
}

