/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;

public class FallbackEntityRenderPatch<T extends Entity>
extends EntityRenderPatch<T> {
    private static final float SCALE = 0.0625f;
    private final BakedArmature armature;

    public FallbackEntityRenderPatch(BakedArmatureTransformer transformer, SkinRenderData renderData) {
        super(renderData);
        this.transformer = transformer;
        this.armature = BakedArmature.mutableBy(transformer.getArmature());
    }

    public static <T extends Entity> void activate(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._activate(FallbackEntityRenderPatch.class, entity, partialTicks, packedLight, poseStackIn, buffersIn, null, handler, renderData -> {
            BakedArmatureTransformer transformer = SkinRendererManager.getFallbackTransformer(entity.m_6095_());
            if (transformer != null) {
                return new FallbackEntityRenderPatch(transformer, (SkinRenderData)renderData);
            }
            return null;
        });
    }

    public static <T extends Entity> void apply(T entity, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._apply(FallbackEntityRenderPatch.class, entity, handler);
    }

    public static <T extends Entity> void deactivate(T entity, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._deactivate(FallbackEntityRenderPatch.class, entity, handler);
    }

    @Override
    protected void onApply(Entity entity) {
        this.poseStack.pushPose();
        this.transformer.activate(entity, this);
        this.transformer.applyTo(this.armature);
        this.poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        ClientWardrobeHandler.render(entity, this.armature, this, this.renderData::getItemSkins);
        this.poseStack.popPose();
    }
}

