/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightTransformProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightModel;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EpicFightEntityRendererPatch<T extends LivingEntity>
extends EntityRenderPatch<T> {
    private EntityModel<?> entityModel;
    private IPoseStack overridePoseStack;
    private EpicFlightModel transformerModel;

    public EpicFightEntityRendererPatch(SkinRenderData renderData) {
        super(renderData);
    }

    public static <T extends LivingEntity> void activate(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, LivingEntityRenderer<?, ?> entityRenderer, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._activate(EpicFightEntityRendererPatch.class, entity, partialTicks, packedLight, poseStackIn, buffersIn, entityRenderer, handler, renderData -> {
            EpicFlightModel model = EpicFlightModel.ofNullable(entityRenderer.m_7200_());
            if (model != null) {
                return new EpicFightEntityRendererPatch((SkinRenderData)renderData);
            }
            return null;
        });
    }

    public static <T extends LivingEntity> void apply(T entity, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._apply(EpicFightEntityRendererPatch.class, entity, handler);
    }

    public static <T extends LivingEntity> void deactivate(T entity, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._deactivate(EpicFightEntityRendererPatch.class, entity, handler);
    }

    @Override
    protected final void onInit(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, EntityRenderer<?> entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            this.onInit(entity, partialTicks, packedLight, poseStackIn, buffersIn, (LivingEntityRenderer)entityRenderer);
        }
    }

    protected void onInit(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, LivingEntityRenderer<?, ?> entityRenderer) {
        super.onInit(entity, partialTicks, packedLight, poseStackIn, buffersIn, (EntityRenderer<?>)entityRenderer);
        EntityModel entityModel = entityRenderer.m_7200_();
        if (this.entityModel != entityModel) {
            this.entityModel = entityModel;
            this.transformerModel = EpicFlightModel.ofNullable(entityModel);
            this.transformer = this.createTransformer((Entity)entity, this.transformerModel, entityRenderer);
        }
    }

    public void setFirstPerson(boolean isFirstPerson) {
        if (this.transformer == null) {
            return;
        }
        if (isFirstPerson) {
            this.transformer.setFilter(joint -> !joint.getName().equals("Head") && !joint.getName().equals("Chest") && !joint.getName().equals("Torso"));
        } else {
            this.transformer.setFilter(null);
        }
    }

    public void setMesh(Object mesh) {
        if (this.transformerModel != null) {
            this.transformerModel.linkTo(mesh);
        }
    }

    public void setTransformProvider(EpicFlightTransformProvider transformProvider) {
        if (this.transformerModel != null) {
            this.transformerModel.setAssociatedObject(transformProvider, EpicFlightTransformProvider.KEY);
        }
    }

    public void setOverridePose(IPoseStack pose) {
        this.overridePoseStack = pose;
    }

    public IPoseStack getOverridePose() {
        if (this.overridePoseStack != null) {
            return this.overridePoseStack;
        }
        return this.poseStack;
    }

    private BakedArmatureTransformer createTransformer(Entity entity, EpicFlightModel model, LivingEntityRenderer<?, ?> entityRenderer) {
        ArmatureTransformer transformer;
        if (model != null && (transformer = SkinRendererManager2.EPICFIGHT.getTransformer(entity.m_6095_(), model)) != null) {
            return BakedArmatureTransformer.create(transformer, entityRenderer);
        }
        return null;
    }
}

