/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TickUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;

public abstract class EntityRenderPatch<T extends Entity>
extends SkinRenderContext {
    protected final int libraryVersion = SkinRendererManager.getVersion();
    protected BakedArmatureTransformer transformer;

    public EntityRenderPatch(SkinRenderData renderData) {
        super(null);
        this.setRenderData(renderData);
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _activate(Class<?> clazz, T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, EntityRenderer<?> entityRenderer, Consumer<P> handler, Function<SkinRenderData, EntityRenderPatch<? extends T>> provider) {
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        EntityRenderPatch renderPatch = renderData.getRenderPatch();
        if (!clazz.isInstance(renderPatch) || !renderPatch.isValid()) {
            EntityRenderPatch<? extends T> renderPatch1 = provider.apply(renderData);
            renderPatch = (EntityRenderPatch)ObjectUtils.unsafeCast(renderPatch1);
            renderData.setRenderPatch(renderPatch);
            if (renderPatch == null) {
                return;
            }
        }
        renderPatch.onInit(entity, partialTicks, packedLight, poseStackIn, buffersIn, entityRenderer);
        renderPatch.onActivate(entity);
        if (handler != null) {
            handler.accept((EntityRenderPatch)ObjectUtils.unsafeCast(renderPatch));
        }
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _apply(Class<?> clazz, T entity, Consumer<P> handler) {
        EntityRenderPatch<? super Entity> renderPatch;
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.getRenderPatch())) {
            if (handler != null) {
                handler.accept((EntityRenderPatch)ObjectUtils.unsafeCast(renderPatch));
            }
            renderPatch.onApply(entity);
        }
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _deactivate(Class<?> clazz, T entity, Consumer<P> handler) {
        EntityRenderPatch<? super Entity> renderPatch;
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.getRenderPatch())) {
            renderPatch.onDeactivate(entity);
            if (handler != null) {
                handler.accept((EntityRenderPatch)ObjectUtils.unsafeCast(renderPatch));
            }
        }
    }

    protected void onInit(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, EntityRenderer<?> entityRenderer) {
        this.setPartialTicks(partialTicks);
        this.setAnimationTicks(TickUtils.ticks());
        this.setLightmap(packedLight);
        this.setPose(AbstractPoseStack.wrap(poseStackIn));
        this.setBuffers(AbstractBufferSource.wrap(buffersIn));
    }

    protected void onActivate(T entity) {
        if (this.transformer != null) {
            this.transformer.prepare((Entity)entity, this);
        }
    }

    protected void onApply(T entity) {
        if (this.transformer != null) {
            this.transformer.activate((Entity)entity, this);
        }
    }

    protected void onDeactivate(T entity) {
        if (this.transformer != null) {
            this.transformer.deactivate((Entity)entity, this);
        }
    }

    public boolean isValid() {
        return this.libraryVersion == SkinRendererManager.getVersion();
    }

    public BakedArmatureTransformer getTransformer() {
        return this.transformer;
    }
}

