/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import com.google.common.collect.ImmutableMap;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModels;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultLayerArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayHeadJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultBabyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultSkirtJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.FlatWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.HorseBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.ArrowModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.BoatModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.FishingModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.MinecartModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.TridentModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.VillagerModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import net.minecraft.resources.ResourceLocation;

public class SkinRendererManager2
extends ArmatureSerializers {
    public static final ArmatureTransformerManager DEFAULT = new DefaultArmatureTransformerManager();
    public static final ArmatureTransformerManager EPICFIGHT = new EpicFlightArmatureTransformerManager();
    private static final ImmutableMap<String, ArmatureTransformerManager> MANAGERS = ImmutableMap.builder().put((Object)"armourers_workshop:armature", (Object)DEFAULT).put((Object)"epicfight:armature", (Object)EPICFIGHT).build();

    public static void init() {
        SkinRendererManager2.registerModifiers();
        SkinRendererManager2.registerPlugins();
        SkinRendererManager2.registerClasses();
        DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/transformers", SimpleLoader::new, SimpleLoader::clean, SimpleLoader::freeze, 0);
    }

    private static void registerModifiers() {
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/baby_head_apt", DefaultBabyJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/body_to_skirt", DefaultSkirtJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/body_to_flat_wing", FlatWingJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_head", AllayHeadJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_body", AllayBodyJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_wing", AllayWingJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_horse_body", HorseBodyJointModifier::new);
    }

    private static void registerPlugins() {
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_villager_layer", DefaultLayerArmaturePlugin::villager);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_mob_layer", DefaultLayerArmaturePlugin::mob);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_slime_layer", DefaultLayerArmaturePlugin::slime);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_villager_model", VillagerModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_trident_model", TridentModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_arrow_model", ArrowModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_fishing_model", FishingModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_boat_model", BoatModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_minecart_model", MinecartModelArmaturePlugin::new);
    }

    private static void registerClasses() {
        SkinRendererManager2.registerClass("minecraft:model/illager", AbstractSkinnableModels.ILLAGER);
        SkinRendererManager2.registerClass("minecraft:model/zombie_villager", AbstractSkinnableModels.ZOMBIE_VILLAGER);
        SkinRendererManager2.registerClass("minecraft:model/villager", AbstractSkinnableModels.VILLAGER);
        SkinRendererManager2.registerClass("minecraft:model/iron_golem", AbstractSkinnableModels.IRON_GOLEM);
        SkinRendererManager2.registerClass("minecraft:model/enderman", AbstractSkinnableModels.ENDERMAN);
        SkinRendererManager2.registerClass("minecraft:model/player", AbstractSkinnableModels.PLAYER);
        SkinRendererManager2.registerClass("minecraft:model/humanoid", AbstractSkinnableModels.HUMANOID);
        SkinRendererManager2.registerClass("minecraft:model/slime", AbstractSkinnableModels.SLIME);
        SkinRendererManager2.registerClass("minecraft:model/ghast", AbstractSkinnableModels.GHAST);
        SkinRendererManager2.registerClass("minecraft:model/chicken", AbstractSkinnableModels.CHICKEN);
        SkinRendererManager2.registerClass("minecraft:model/creeper", AbstractSkinnableModels.CREEPER);
        SkinRendererManager2.registerClass("minecraft:model/horse", AbstractSkinnableModels.HORSE);
        SkinRendererManager2.registerClass("minecraft:model/boat", AbstractSkinnableModels.BOAT);
        SkinRendererManager2.registerClass("minecraft:model/raft", AbstractSkinnableModels.RAFT);
        SkinRendererManager2.registerClass("minecraft:model/allay", AbstractSkinnableModels.ALLAY);
    }

    public static class SimpleLoader
    implements IDataPackBuilder {
        private final ResourceLocation location;

        public SimpleLoader(ResourceLocation location) {
            this.location = location;
        }

        @Override
        public void append(IDataPackObject object, ResourceLocation file) {
            String type = object.get("type").stringValue();
            ArmatureTransformerManager manager = (ArmatureTransformerManager)MANAGERS.get((Object)type);
            if (manager != null) {
                manager.append(object, this.location);
            }
        }

        @Override
        public void build() {
        }

        public static void clean() {
            MANAGERS.values().forEach(ArmatureTransformerManager::clear);
        }

        public static void freeze() {
            MANAGERS.values().forEach(ArmatureTransformerManager::freeze);
        }
    }
}

