/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererManager {
    private static int VERSION = 0;
    private static boolean IS_READY = false;
    private static final HashMap<EntityType<?>, BakedArmatureTransformer> FALLBACK_TRANSFORMERS = new HashMap();
    private static final HashMap<IEntityTypeProvider<?>, EntityProfile> ENTITIES = new HashMap();

    public static void init() {
        ModEntityProfiles.addListener(SkinRendererManager::unbind, SkinRendererManager::bind);
        SkinRendererManager.reload();
    }

    public static void reload() {
        EntityRenderDispatcher entityRenderManager = Minecraft.m_91087_().m_91290_();
        if (entityRenderManager == null) {
            RenderSystem.recordRenderCall(SkinRendererManager::reload);
            return;
        }
        RenderSystem.recordRenderCall(() -> SkinRendererManager._reload(entityRenderManager));
    }

    private static void _reload(EntityRenderDispatcher entityRenderManager) {
        for (EntityRenderer renderer : entityRenderManager.f_114363_.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            SkinRendererManager.setupRenderer(EntityType.f_20532_, (LivingEntityRenderer)renderer, true);
        }
        entityRenderManager.f_114362_.forEach((entityType1, entityRenderer) -> {
            if (entityRenderer instanceof LivingEntityRenderer) {
                SkinRendererManager.setupRenderer(entityType1, (LivingEntityRenderer)entityRenderer, true);
            }
        });
        IS_READY = false;
        FALLBACK_TRANSFORMERS.clear();
        ENTITIES.forEach(SkinRendererManager::_bind);
        ++VERSION;
        IS_READY = true;
    }

    public static void unbind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Detach Entity Renderer '{}'", entityType.getRegistryName());
        ENTITIES.remove(entityType);
        if (IS_READY) {
            // empty if block
        }
    }

    public static void bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Attach Entity Renderer '{}'", entityType.getRegistryName());
        ENTITIES.put(entityType, entityProfile);
        if (IS_READY) {
            SkinRendererManager._bind(entityType, entityProfile);
        }
    }

    private static void _bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        EntityType resolvedEntityType = (EntityType)entityType.get();
        if (resolvedEntityType == null) {
            return;
        }
        EntityRenderDispatcher entityRenderManager = Minecraft.m_91087_().m_91290_();
        if (entityRenderManager == null) {
            return;
        }
        if (resolvedEntityType == EntityType.f_20532_) {
            for (EntityRenderer renderer2 : entityRenderManager.f_114363_.values()) {
                if (!(renderer2 instanceof LivingEntityRenderer)) continue;
                SkinRendererManager.setupRenderer(resolvedEntityType, (LivingEntityRenderer)renderer2, false);
            }
        }
        entityRenderManager.f_114362_.forEach((entityType1, renderer) -> {
            if (resolvedEntityType.equals(entityType1)) {
                if (renderer instanceof LivingEntityRenderer) {
                    SkinRendererManager.setupRenderer(resolvedEntityType, (LivingEntityRenderer)renderer, false);
                } else {
                    SkinRendererManager.setupFallbackRenderer(resolvedEntityType, renderer);
                }
            }
        });
    }

    private static <T extends LivingEntity, V extends EntityModel<T>> void setupRenderer(EntityType<?> entityType, LivingEntityRenderer<T, V> livingRenderer, boolean autoInject) {
        RenderLayer armorLayer = null;
        for (RenderLayer layerRenderer : livingRenderer.f_115291_) {
            if (layerRenderer instanceof HumanoidArmorLayer) {
                armorLayer = layerRenderer;
            }
            if (!(layerRenderer instanceof SkinWardrobeLayer)) continue;
            return;
        }
        if (autoInject && armorLayer == null) {
            return;
        }
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entityType, (Model)livingRenderer.m_7200_(), livingRenderer);
        if (transformer != null) {
            livingRenderer.m_115326_(new SkinWardrobeLayer(transformer, livingRenderer));
        }
    }

    private static <T extends Entity> void setupFallbackRenderer(EntityType<?> entityType, EntityRenderer<T> renderer) {
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entityType, null, renderer);
        if (transformer != null) {
            FALLBACK_TRANSFORMERS.put(entityType, transformer);
        }
    }

    public static BakedArmatureTransformer getFallbackTransformer(EntityType<?> entityType) {
        return FALLBACK_TRANSFORMERS.get(entityType);
    }

    public static int getVersion() {
        return VERSION;
    }
}

