/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Stack;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public abstract class ShaderUniform {
    protected final String name;
    protected final int program;
    protected final int location;

    ShaderUniform(String name, int program, int location) {
        this.name = name;
        this.program = program;
        this.location = location;
    }

    public abstract void apply();

    public void push() {
    }

    public void pop() {
    }

    public static class Loader {
        final int programId;
        final ArrayList<String> registeredNames = new ArrayList();
        final ArrayList<ShaderUniform> uniforms = new ArrayList();

        public Loader(int programId) {
            this.programId = programId;
            this.register("aw_MatrixFlags", RenderSystem::getExtendedMatrixFlags, Int::new);
            this.register("aw_LightmapTextureMatrix", RenderSystem::getExtendedLightmapTextureMatrix, Matrix4f::new);
            this.register("aw_TextureMatrix", RenderSystem::getExtendedTextureMatrix, Matrix4f::new);
            this.register("aw_NormalMatrix", RenderSystem::getExtendedNormalMatrix, Matrix3f::new);
            this.register("aw_ModelViewMat", RenderSystem::getExtendedModelViewMatrix, Matrix4f::new);
        }

        private <T> void register(String name, Supplier<T> supplier, Factory<T> factory) {
            int location = GL20.glGetUniformLocation((int)this.programId, (CharSequence)name);
            if (location != -1) {
                this.uniforms.add(factory.create(name, this.programId, location, supplier));
                this.registeredNames.add(name);
            }
        }
    }

    public static class Matrix3f
    extends ShaderUniform {
        private final FloatBuffer buffer = ObjectUtils.createFloatBuffer(9);
        private final Supplier<OpenMatrix3f> value;
        private OpenMatrix3f cachedValue = null;

        Matrix3f(String name, int program, int location, Supplier<OpenMatrix3f> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            OpenMatrix3f newValue = this.value.get();
            if (!newValue.equals(this.cachedValue)) {
                this.cachedValue = newValue.copy();
                this.cachedValue.store(this.buffer);
                this.buffer.rewind();
                GL20.glUniformMatrix3fv((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
            }
        }
    }

    public static class Matrix4f
    extends ShaderUniform {
        private final FloatBuffer buffer = ObjectUtils.createFloatBuffer(16);
        private final Supplier<OpenMatrix4f> value;
        private OpenMatrix4f cachedValue = null;

        Matrix4f(String name, int program, int location, Supplier<OpenMatrix4f> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            OpenMatrix4f newValue = this.value.get();
            if (!newValue.equals(this.cachedValue)) {
                this.cachedValue = newValue.copy();
                this.cachedValue.store(this.buffer);
                this.buffer.rewind();
                GL20.glUniformMatrix4fv((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
            }
        }
    }

    public static class Int
    extends ShaderUniform {
        private final Supplier<Integer> value;
        private final Stack<Integer> cachedValues = new Stack();
        private int cachedValue = 0;

        Int(String name, int program, int location, Supplier<Integer> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            int newValue = this.value.get();
            if (this.cachedValue != newValue) {
                this.cachedValue = newValue;
                GL20.glUniform1i((int)this.location, (int)newValue);
            }
        }

        @Override
        public void push() {
            this.cachedValues.push(this.cachedValue);
        }

        @Override
        public void pop() {
            int newValue;
            this.cachedValue = newValue = this.cachedValues.pop().intValue();
            GL20.glUniform1i((int)this.location, (int)newValue);
        }
    }

    public static interface Factory<T> {
        public ShaderUniform create(String var1, int var2, int var3, Supplier<T> var4);
    }
}

