/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinnableBlockRenderer<T extends SkinnableBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final BakedArmature armature = new BakedArmature(Armatures.ANY);
    private final Supplier<MannequinEntity> placeholder = PlaceholderManager.MANNEQUIN;

    public SkinnableBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinDescriptor descriptor = ((SkinnableBlockEntity)entity).getDescriptor();
        BakedSkin skin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (skin == null) {
            return;
        }
        float f = 0.0625f;
        BlockState blockState = entity.m_58900_();
        OpenQuaternionf rotations = ((SkinnableBlockEntity)entity).getRenderRotations(blockState);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.rotate(rotations);
        poseStack.scale(f, f, f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        SkinRenderContext context = SkinRenderContext.alloc(null, light, partialTicks, poseStack, bufferSource);
        SkinRenderer.render((Entity)this.placeholder.get(), this.armature, skin, descriptor.getColorScheme(), context);
        context.release();
        poseStack.popPose();
        if (ModDebugger.skinnable) {
            skin.getBlockBounds().forEach((pos, rect) -> {
                poseStack.pushPose();
                poseStack.translate(0.5f, 0.5f, 0.5f);
                poseStack.scale(f, f, f);
                poseStack.rotate(rotations);
                poseStack.translate((float)pos.m_123341_() * 16.0f, (float)pos.m_123342_() * 16.0f, (float)pos.m_123343_() * 16.0f);
                ShapeTesselator.stroke(rect, UIColor.RED, poseStack, bufferSource);
                poseStack.popPose();
            });
            BlockPos pos2 = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos2.m_123341_(), -pos2.m_123342_(), -pos2.m_123343_());
            ShapeTesselator.stroke(((SkinnableBlockEntity)entity).getRenderShape(blockState), UIColor.ORANGE, poseStack, bufferSource);
            poseStack.popPose();
        }
    }
}

