/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorBlockRenderer<T extends HologramProjectorBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public HologramProjectorBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        if (!((HologramProjectorBlockEntity)entity).isPowered()) {
            return;
        }
        BlockState blockState = entity.m_58900_();
        ItemStack itemStack = ((UpdatableContainerBlockEntity)entity).m_8020_(0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.RENDERER);
        if (context == null) {
            return;
        }
        float f = 0.0625f;
        float partialTicks1 = TickUtils.ticks();
        int overLight = light;
        if (((HologramProjectorBlockEntity)entity).isOverrideLight()) {
            overLight = 0xF000F0;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.rotate(((HologramProjectorBlockEntity)entity).getRenderRotations(blockState));
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.scale(f, f, f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        context.setLightmap(overLight);
        context.setPartialTicks(partialTicks1);
        context.setColorScheme(descriptor.getColorScheme());
        context.setReferenced(SkinItemSource.create(itemStack));
        Rectangle3f rect = context.getBakedRenderBounds();
        this.apply(entity, rect, partialTicks1, poseStack, bufferSource);
        context.draw(poseStack, bufferSource);
        poseStack.popPose();
        if (ModDebugger.hologramProjector) {
            BlockPos pos = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_());
            ShapeTesselator.stroke(((HologramProjectorBlockEntity)entity).getRenderShape(blockState), UIColor.ORANGE, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    private void apply(T entity, Rectangle3f rect, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource) {
        Vector3f angle = ((HologramProjectorBlockEntity)entity).getModelAngle();
        Vector3f offset = ((HologramProjectorBlockEntity)entity).getModelOffset();
        Vector3f rotationOffset = ((HologramProjectorBlockEntity)entity).getRotationOffset();
        Vector3f rotationSpeed = ((HologramProjectorBlockEntity)entity).getRotationSpeed();
        float rotX = angle.getX();
        float speedX = rotationSpeed.getX();
        if (speedX != 0.0f) {
            rotX += partialTicks % speedX / speedX * 360.0f;
        }
        float rotY = angle.getY();
        float speedY = rotationSpeed.getY();
        if (speedY != 0.0f) {
            rotY += partialTicks % speedY / speedY * 360.0f;
        }
        float rotZ = angle.getZ();
        float speedZ = rotationSpeed.getZ();
        if (speedZ != 0.0f) {
            rotZ += partialTicks % speedZ / speedZ * 360.0f;
        }
        float scale = ((HologramProjectorBlockEntity)entity).getModelScale();
        poseStack.scale(scale, scale, scale);
        if (((HologramProjectorBlockEntity)entity).isOverrideOrigin()) {
            poseStack.translate(0.0f, -rect.getMaxY(), 0.0f);
        }
        poseStack.translate(-offset.getX(), -offset.getY(), offset.getZ());
        if (((HologramProjectorBlockEntity)entity).shouldShowRotationPoint()) {
            ShapeTesselator.stroke(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, UIColor.MAGENTA, poseStack, bufferSource);
        }
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(Vector3f.ZERO, 128.0f, poseStack, bufferSource);
        }
        poseStack.rotate(new OpenQuaternionf(rotX, -rotY, rotZ, true));
        poseStack.translate(rotationOffset.getX(), -rotationOffset.getY(), rotationOffset.getZ());
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(Vector3f.ZERO, 128.0f, poseStack, bufferSource);
        }
    }

    public int m_142163_() {
        return 272;
    }
}

