/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.nio.ByteBuffer;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public class VertexIndexBuffer {
    private final int vertexStride;
    private final int indexStride;
    private final IndexGenerator generator;
    private int name;
    private int indexCount;
    private IndexType type = IndexType.BYTE;

    public VertexIndexBuffer(int i, int j, IndexGenerator generator) {
        this.vertexStride = i;
        this.indexStride = j;
        this.generator = generator;
    }

    public boolean hasStorage(int i) {
        return i <= this.indexCount;
    }

    public void bind(int total) {
        if (this.name == 0) {
            this.name = GL15.glGenBuffers();
        }
        GL15.glBindBuffer((int)34963, (int)this.name);
        this.ensureStorage(total);
    }

    public void unbind() {
        GL15.glBindBuffer((int)34963, (int)0);
    }

    private void ensureStorage(int total) {
        if (this.hasStorage(total)) {
            return;
        }
        total = MathUtils.roundToward(total * 2, this.indexStride);
        ModLog.debug("growing index buffer {} => {}.", this.indexCount, total);
        IndexType indexType = IndexType.least(total);
        int j = MathUtils.roundToward(total * indexType.bytes, 4);
        GL15.glBufferData((int)34963, (long)j, (int)35048);
        ByteBuffer buffer = GL15.glMapBuffer((int)34963, (int)35001);
        if (buffer == null) {
            throw new RuntimeException("Failed to map GL buffer");
        }
        this.type = indexType;
        IntConsumer builder = this.createBuilder(buffer);
        for (int k = 0; k < total; k += this.indexStride) {
            this.generator.accept(builder, k * this.vertexStride / this.indexStride);
        }
        GL15.glUnmapBuffer((int)34963);
        this.indexCount = total;
    }

    private IntConsumer createBuilder(ByteBuffer buffer) {
        switch (this.type.ordinal()) {
            case 0: {
                return i -> buffer.put((byte)i);
            }
            case 1: {
                return i -> buffer.putShort((short)i);
            }
        }
        return buffer::putInt;
    }

    public IndexType type() {
        return this.type;
    }

    public static enum IndexType {
        BYTE(5121, 1),
        SHORT(5123, 2),
        INT(5125, 4);

        public final int asGLType;
        public final int bytes;

        private IndexType(int type, int bytes) {
            this.asGLType = type;
            this.bytes = bytes;
        }

        public static IndexType least(int i) {
            if ((i & 0xFFFF0000) != 0) {
                return INT;
            }
            if ((i & 0xFF00) != 0) {
                return SHORT;
            }
            return BYTE;
        }
    }

    public static interface IndexGenerator {
        public void accept(IntConsumer var1, int var2);
    }
}

