/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinOverriddenManager {
    private static final ImmutableList<EquipmentSlot> ARMOUR_EQUIPMENT_SLOTS = new ImmutableList.Builder().add((Object)EquipmentSlot.HEAD).add((Object)EquipmentSlot.CHEST).add((Object)EquipmentSlot.LEGS).add((Object)EquipmentSlot.FEET).build();
    private static final ImmutableList<ISkinProperty<Boolean>> OVERRIDDEN_PROPERTIES = new ImmutableList.Builder().add(SkinProperty.OVERRIDE_MODEL_HEAD).add(SkinProperty.OVERRIDE_MODEL_CHEST).add(SkinProperty.OVERRIDE_MODEL_LEFT_ARM).add(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM).add(SkinProperty.OVERRIDE_MODEL_LEFT_LEG).add(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG).add(SkinProperty.OVERRIDE_MODEL_LEFT_FRONT_LEG).add(SkinProperty.OVERRIDE_MODEL_RIGHT_FRONT_LEG).add(SkinProperty.OVERRIDE_MODEL_LEFT_HIND_LEG).add(SkinProperty.OVERRIDE_MODEL_RIGHT_HIND_LEG).add(SkinProperty.OVERRIDE_MODEL_TAIL).add(SkinProperty.OVERRIDE_OVERLAY_HAT).add(SkinProperty.OVERRIDE_OVERLAY_CLOAK).add(SkinProperty.OVERRIDE_OVERLAY_JACKET).add(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE).add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE).add(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS).add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS).add(SkinProperty.OVERRIDE_EQUIPMENT_HELMET).add(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE).add(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS).add(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS).build();
    private static final ImmutableMap<ISkinProperty<Boolean>, EquipmentSlot> OVERRIDDEN_EQUIPMENT_TO_SLOT = new ImmutableMap.Builder().put(SkinProperty.OVERRIDE_EQUIPMENT_HELMET, (Object)EquipmentSlot.HEAD).put(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, (Object)EquipmentSlot.CHEST).put(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, (Object)EquipmentSlot.LEGS).put(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, (Object)EquipmentSlot.FEET).build();
    private static final ImmutableMap<ISkinProperty<Boolean>, Collection<ISkinProperty<Boolean>>> OVERRIDDEN_MODEL_TO_OVERLAY = new ImmutableMap.Builder().put(SkinProperty.OVERRIDE_MODEL_HEAD, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_HAT)).put(SkinProperty.OVERRIDE_MODEL_CHEST, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_CLOAK)).put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE)).put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE)).put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS)).put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, ObjectUtils.map(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS)).build();
    private final HashSet<ISkinProperty<Boolean>> disabledProperties = new HashSet();
    private final HashSet<ISkinProperty<Boolean>> disabledModelByProperties = new HashSet();
    private final HashSet<EquipmentSlot> disabledEquipmentSlots = new HashSet();
    private final HashSet<EquipmentSlot> disabledEquipmentSlotsByProperties = new HashSet();
    private final HashMap<EquipmentSlot, ItemStack> disabledEquipmentItems = new HashMap();

    public void addEquipment(EquipmentSlot slotType) {
        this.disabledEquipmentSlots.add(slotType);
    }

    public void removeEquipment(EquipmentSlot slotType) {
        this.disabledEquipmentSlots.remove(slotType);
    }

    public void addProperty(ISkinProperty<Boolean> property) {
        Collection overlayProperties;
        this.disabledProperties.add(property);
        EquipmentSlot equipmentSlot = (EquipmentSlot)OVERRIDDEN_EQUIPMENT_TO_SLOT.get(property);
        if (equipmentSlot != null) {
            this.disabledEquipmentSlotsByProperties.add(equipmentSlot);
        }
        if ((overlayProperties = (Collection)OVERRIDDEN_MODEL_TO_OVERLAY.get(property)) != null) {
            this.disabledModelByProperties.add(property);
            this.disabledProperties.addAll(overlayProperties);
        }
    }

    public void merge(ISkinProperties properties) {
        for (ISkinProperty property : OVERRIDDEN_PROPERTIES) {
            if (!((Boolean)properties.get(property)).booleanValue()) continue;
            this.addProperty(property);
        }
    }

    public boolean contains(ISkinProperty<Boolean> property) {
        return this.disabledProperties.contains(property);
    }

    public boolean overrideEquipment(EquipmentSlot slotType) {
        return this.disabledEquipmentSlots.contains(slotType) || this.disabledEquipmentSlotsByProperties.contains(slotType);
    }

    public boolean overrideAnyModel() {
        return !this.disabledModelByProperties.isEmpty();
    }

    public void clear() {
        this.disabledProperties.clear();
        this.disabledModelByProperties.clear();
        this.disabledEquipmentSlots.clear();
        this.disabledEquipmentSlotsByProperties.clear();
    }

    public void willRender(Entity entity) {
        for (EquipmentSlot slotType : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.overrideEquipment(slotType) || this.disabledEquipmentItems.containsKey(slotType)) continue;
            ItemStack itemStack = this.setItem(entity, slotType, ItemStack.f_41583_);
            this.disabledEquipmentItems.put(slotType, itemStack);
        }
    }

    public void didRender(Entity entity) {
        for (EquipmentSlot slotType : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.disabledEquipmentItems.containsKey(slotType)) continue;
            ItemStack itemStack = this.disabledEquipmentItems.remove(slotType);
            this.setItem(entity, slotType, itemStack);
        }
    }

    private ItemStack setItem(Entity entity, EquipmentSlot slotType, ItemStack itemStack) {
        if (entity instanceof Player) {
            Inventory inventory = ((Player)entity).m_150109_();
            ItemStack itemStack1 = (ItemStack)inventory.f_35975_.get(slotType.m_20749_());
            inventory.f_35975_.set(slotType.m_20749_(), (Object)itemStack);
            return itemStack1;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack itemStack1 = livingEntity.m_6844_(slotType);
            livingEntity.m_8061_(slotType, itemStack);
            return itemStack1;
        }
        return itemStack;
    }
}

