/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.molang.math;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import moe.plushie.armourers_workshop.core.client.molang.math.Variable;

public class LazyVariable
extends Variable {
    private DoubleSupplier valueSupplier;

    public LazyVariable(String name, double value) {
        super(name, value);
    }

    public LazyVariable(String name, DoubleSupplier valueSupplier) {
        super(name, 0.0);
        this.valueSupplier = valueSupplier;
    }

    public static LazyVariable from(Variable variable) {
        return new LazyVariable(variable.getName(), variable.get());
    }

    @Override
    public void set(double value) {
        super.set(value);
        this.valueSupplier = null;
    }

    public void set(BooleanSupplier valueSupplier) {
        this.set(() -> {
            if (valueSupplier.getAsBoolean()) {
                return 1.0;
            }
            return 0.0;
        });
    }

    public void set(DoubleSupplier valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    @Override
    public double get() {
        if (this.valueSupplier != null) {
            this.set(this.valueSupplier.getAsDouble());
        }
        return super.get();
    }
}

