/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.molang;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import moe.plushie.armourers_workshop.core.client.molang.MolangException;
import moe.plushie.armourers_workshop.core.client.molang.expressions.MolangCompoundValue;
import moe.plushie.armourers_workshop.core.client.molang.expressions.MolangValue;
import moe.plushie.armourers_workshop.core.client.molang.expressions.MolangVariableHolder;
import moe.plushie.armourers_workshop.core.client.molang.functions.utility.CosDegrees;
import moe.plushie.armourers_workshop.core.client.molang.functions.utility.SinDegrees;
import moe.plushie.armourers_workshop.core.client.molang.math.Constant;
import moe.plushie.armourers_workshop.core.client.molang.math.IValue;
import moe.plushie.armourers_workshop.core.client.molang.math.LazyVariable;
import moe.plushie.armourers_workshop.core.client.molang.math.MathBuilder;
import moe.plushie.armourers_workshop.core.client.molang.math.Variable;

public class MolangParser
extends MathBuilder {
    public static final MolangVariableHolder ZERO = new MolangVariableHolder(null, new Constant(0.0));
    public static final MolangVariableHolder ONE = new MolangVariableHolder(null, new Constant(1.0));
    public static final String RETURN = "return ";

    public MolangParser() {
        this.doCoreRemaps();
    }

    public MolangValue parseJson(JsonElement element) throws MolangException {
        if (!element.isJsonPrimitive()) {
            return ZERO;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isNumber()) {
            return new MolangValue(new Constant(primitive.getAsDouble()));
        }
        if (primitive.isString()) {
            String string = primitive.getAsString();
            try {
                return new MolangValue(new Constant(Double.parseDouble(string)));
            }
            catch (NumberFormatException ex) {
                return this.parseExpression(string);
            }
        }
        return ZERO;
    }

    public MolangValue parseExpression(String expression) throws MolangException {
        MolangCompoundValue result = null;
        for (String split : expression.toLowerCase().trim().split(";")) {
            String trimmed = split.trim();
            if (trimmed.isEmpty()) continue;
            if (result == null) {
                result = new MolangCompoundValue(this.parseOneLine(trimmed, result));
                continue;
            }
            result.values.add(this.parseOneLine(trimmed, result));
        }
        if (result == null) {
            throw new MolangException("Molang expression cannot be blank!");
        }
        return result;
    }

    protected MolangValue parseOneLine(String expression, MolangCompoundValue currentStatement) throws MolangException {
        if (expression.startsWith(RETURN)) {
            try {
                return new MolangValue(this.parse(expression.substring(RETURN.length())), true);
            }
            catch (Exception e) {
                throw new MolangException("Couldn't parse return '" + expression + "' expression!");
            }
        }
        try {
            List<Object> symbols = this.breakdownChars(this.breakdown(expression));
            if (symbols.size() >= 3 && symbols.get(0) instanceof String && this.isVariable(symbols.get(0)) && symbols.get(1).equals("=")) {
                Variable variable;
                String name = (String)(symbols = symbols.subList(2, symbols.size())).get(0);
                if (!this.variables.containsKey(name) && !currentStatement.locals.containsKey(name)) {
                    LazyVariable local = new LazyVariable(name, 0.0);
                    currentStatement.locals.put(name, local);
                    variable = local;
                } else {
                    variable = this.getVariable(name, currentStatement);
                }
                return new MolangVariableHolder(variable, this.parseSymbolsMolang(symbols));
            }
            return new MolangValue(this.parseSymbolsMolang(symbols));
        }
        catch (Exception e) {
            throw new MolangException("Couldn't parse '" + expression + "' expression!");
        }
    }

    private void doCoreRemaps() {
        this.functions.put("cos", CosDegrees.class);
        this.functions.put("sin", SinDegrees.class);
        this.remap("abs", "math.abs");
        this.remap("acos", "math.acos");
        this.remap("asin", "math.asin");
        this.remap("atan", "math.atan");
        this.remap("atan2", "math.atan2");
        this.remap("ceil", "math.ceil");
        this.remap("clamp", "math.clamp");
        this.remap("cos", "math.cos");
        this.remap("die_roll", "math.die_roll");
        this.remap("die_roll_integer", "math.die_roll_integer");
        this.remap("exp", "math.exp");
        this.remap("floor", "math.floor");
        this.remap("hermite_blend", "math.hermite_blend");
        this.remap("lerp", "math.lerp");
        this.remap("lerprotate", "math.lerprotate");
        this.remap("ln", "math.ln");
        this.remap("max", "math.max");
        this.remap("min", "math.min");
        this.remap("mod", "math.mod");
        this.remap("pi", "math.pi");
        this.remap("pow", "math.pow");
        this.remap("random", "math.random");
        this.remap("random_integer", "math.random_integer");
        this.remap("round", "math.round");
        this.remap("sin", "math.sin");
        this.remap("sqrt", "math.sqrt");
        this.remap("trunc", "math.trunc");
    }

    public void remap(String old, String newName) {
        this.functions.put(newName, (Class)this.functions.remove(old));
    }

    @Override
    public Variable getVariable(String name) {
        return this.variables.computeIfAbsent(name, key -> new LazyVariable((String)key, 0.0));
    }

    public Variable getVariable(String name, MolangCompoundValue currentStatement) {
        LazyVariable variable;
        if (currentStatement != null && (variable = currentStatement.locals.get(name)) != null) {
            return variable;
        }
        return this.getVariable(name);
    }

    private IValue parseSymbolsMolang(List<Object> symbols) throws MolangException {
        try {
            return this.parseSymbols(symbols);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MolangException("Couldn't parse an expression!");
        }
    }

    @Override
    protected boolean isOperator(String s) {
        return super.isOperator(s) || s.equals("=");
    }
}

