/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.molang;

import java.util.function.DoubleSupplier;
import moe.plushie.armourers_workshop.core.client.molang.MolangException;
import moe.plushie.armourers_workshop.core.client.molang.MolangParser;
import moe.plushie.armourers_workshop.core.client.molang.expressions.MolangValue;
import moe.plushie.armourers_workshop.core.client.molang.math.LazyVariable;
import moe.plushie.armourers_workshop.core.client.molang.math.Variable;

public class MolangEnvironment {
    private static final MolangEnvironment DEFAULT = new MolangEnvironment();
    private final MolangParser parser = new MolangParser();
    public final LazyVariable animTime = this.register("query.anim_time", 0.0);
    public final LazyVariable lifeTime = this.register("query.life_time", 0.0);
    public final LazyVariable actorCount = this.register("query.actor_count", 0.0);
    public final LazyVariable timeOfDay = this.register("query.time_of_day", 0.0);
    public final LazyVariable moonPhase = this.register("query.moon_phase", 0.0);
    public final LazyVariable distanceFromCamera = this.register("query.distance_from_camera", 0.0);
    public final LazyVariable isOnGround = this.register("query.is_on_ground", 0.0);
    public final LazyVariable isInWater = this.register("query.is_in_water", 0.0);
    public final LazyVariable isInWaterOrRain = this.register("query.is_in_water_or_rain", 0.0);
    public final LazyVariable health = this.register("query.health", 0.0);
    public final LazyVariable maxHealth = this.register("query.max_health", 0.0);
    public final LazyVariable isOnFire = this.register("query.is_on_fire", 0.0);
    public final LazyVariable groundSpeed = this.register("query.ground_speed", 0.0);
    public final LazyVariable yawSpeed = this.register("query.yaw_speed", 0.0);

    public static MolangEnvironment get() {
        return DEFAULT;
    }

    public MolangValue create(String expression) throws MolangException {
        return this.parser.parseExpression(expression);
    }

    public void setValue(String name, Double value) {
        Variable variable = this.parser.getVariable(name);
        variable.set(value);
    }

    public void setValue(String name, DoubleSupplier value) {
        Variable variable = this.parser.getVariable(name);
        if (variable instanceof LazyVariable) {
            ((LazyVariable)variable).set(value);
        } else {
            variable.set(value.getAsDouble());
        }
    }

    public LazyVariable register(String name) {
        return this.register(name, 0.0);
    }

    public LazyVariable register(String name, double value) {
        LazyVariable variable = new LazyVariable(name, value);
        this.parser.register(variable);
        return variable;
    }

    public LazyVariable register(String name, DoubleSupplier value) {
        LazyVariable variable = new LazyVariable(name, value);
        this.parser.register(variable);
        return variable;
    }
}

