/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.core.client.model.LinkedModelPart;
import moe.plushie.armourers_workshop.utils.DataStorage;
import org.jetbrains.annotations.Nullable;

public class LinkedModel
implements IModel {
    private final IModel parent;
    private final DataStorage storage = new DataStorage();
    private final HashMap<String, LinkedModelPart> namedParts = new HashMap();
    private final ArrayList<LinkedModelPart> allParts = new ArrayList();
    private IModel target;

    public LinkedModel(IModel parent) {
        this.parent = parent;
    }

    public void linkTo(IModel target) {
        if (this.target == target) {
            return;
        }
        HashSet exists = new HashSet();
        this.target = target;
        this.allParts.clear();
        this.namedParts.forEach((key, value) -> {
            IModelPart part = target.getPart((String)key);
            value.linkTo(part);
            this.allParts.add((LinkedModelPart)value);
            exists.add(part);
        });
        for (IModelPart iModelPart : target.getAllParts()) {
            if (exists.contains(iModelPart)) continue;
            LinkedModelPart linkedPart = new LinkedModelPart(iModelPart);
            linkedPart.linkTo(iModelPart);
            this.allParts.add(linkedPart);
        }
    }

    @Override
    @Nullable
    public IModelBabyPose getBabyPose() {
        if (this.target != null) {
            return this.target.getBabyPose();
        }
        if (this.parent != null) {
            return this.parent.getBabyPose();
        }
        return null;
    }

    @Override
    public LinkedModelPart getPart(String name) {
        return this.namedParts.computeIfAbsent(name, it -> {
            IModelPart part = null;
            if (this.parent != null) {
                part = this.parent.getPart(name);
            }
            LinkedModelPart linkedPart = new LinkedModelPart(part);
            this.allParts.add(linkedPart);
            return linkedPart;
        });
    }

    @Override
    public Collection<? extends IModelPart> getAllParts() {
        return this.allParts;
    }

    @Override
    public Class<?> getType() {
        if (this.parent != null) {
            return this.parent.getType();
        }
        return this.getClass();
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        if (this.parent != null) {
            return this.parent.getAssociatedObject(key);
        }
        return this.storage.getAssociatedObject(key);
    }

    @Override
    public <T> void setAssociatedObject(T value, IAssociatedContainerKey<T> key) {
        if (this.parent != null) {
            this.parent.setAssociatedObject(value, key);
        } else {
            this.storage.setAssociatedObject(value, key);
        }
    }
}

