/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.layer;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.AbstractRenderLayer;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EpicFightEntityRendererPatch;
import moe.plushie.armourers_workshop.init.ModContributors;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeLayer<T extends Entity, V extends EntityModel<T>, M extends IModel>
extends AbstractRenderLayer<T, V> {
    protected final BakedArmature armature;
    protected final RenderLayerParent<T, V> entityRenderer;

    public SkinWardrobeLayer(BakedArmatureTransformer armatureTransformer, RenderLayerParent<T, V> renderer) {
        super(renderer);
        this.armature = new BakedArmature(armatureTransformer.getArmature());
        this.entityRenderer = renderer;
    }

    @Override
    public void render(T entity, float limbSwing, float limbSwingAmount, int packedLightIn, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, IPoseStack poseStack, IBufferSource bufferSource) {
        ModContributors.Contributor contributor;
        if (entity.m_20145_()) {
            return;
        }
        IPoseStack poseStack1 = poseStack;
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        EntityRenderPatch<? super Entity> renderPatch = renderData.getRenderPatch();
        if (renderPatch == null) {
            return;
        }
        BakedArmatureTransformer transformer = renderPatch.getTransformer();
        if (transformer == null) {
            return;
        }
        EpicFightEntityRendererPatch epicFlightContext = ObjectUtils.safeCast(renderPatch, EpicFightEntityRendererPatch.class);
        if (epicFlightContext != null) {
            poseStack = epicFlightContext.getOverridePose();
        }
        poseStack.pushPose();
        if (epicFlightContext == null) {
            this.applyModelScale(poseStack, ModelHolder.of((Model)this.m_117386_()));
        }
        if ((contributor = ModContributors.by(entity)) != null && renderData.shouldRenderExtra()) {
            this.renderMagicCircle(poseStack1, bufferSource, ((Entity)entity).f_19797_ + entity.m_19879_() * 31, partialTicks, 24, contributor.color, packedLightIn, OverlayTexture.f_118083_);
        }
        float f = 0.0625f;
        poseStack.scale(f, f, f);
        transformer.applyTo(this.armature);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLightIn, partialTicks, null, poseStack, bufferSource);
        for (SkinRenderData.Entry entry : renderData.getArmorSkins()) {
            context.setReferenced(SkinItemSource.create(entry.getRenderPriority(), entry.getItemStack()));
            BakedSkin bakedSkin = entry.getBakedSkin();
            bakedSkin.setupAnim((Entity)entity, context.getAnimationTicks(), context.getReferenced());
            SkinRenderer.render(entity, this.armature, bakedSkin, entry.getBakedScheme(), context);
        }
        context.release();
        poseStack.popPose();
    }

    public void renderMagicCircle(IPoseStack poseStack, IBufferSource bufferSource, int ticks, float partialTickTime, int offset, int color, int lightmap, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.0f, (float)offset / 16.0f, 0.0f);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float circleScale = 2.0f;
        float rotation = (float)((double)ticks / 0.8 % 360.0) + partialTickTime;
        poseStack.rotate(Vector3f.YP.rotationDegrees(rotation));
        poseStack.scale(circleScale, circleScale, circleScale);
        IPoseStack.Pose pose = poseStack.last();
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.IMAGE_MAGIC);
        builder.vertex(pose, -1.0f, 0.0f, -1.0f).color(red, green, blue, 255).uv(1.0f, 0.0f).overlayCoords(overlay).uv2(lightmap).endVertex();
        builder.vertex(pose, 1.0f, 0.0f, -1.0f).color(red, green, blue, 255).uv(0.0f, 0.0f).overlayCoords(overlay).uv2(lightmap).endVertex();
        builder.vertex(pose, 1.0f, 0.0f, 1.0f).color(red, green, blue, 255).uv(0.0f, 1.0f).overlayCoords(overlay).uv2(lightmap).endVertex();
        builder.vertex(pose, -1.0f, 0.0f, 1.0f).color(red, green, blue, 255).uv(1.0f, 1.0f).overlayCoords(overlay).uv2(lightmap).endVertex();
        poseStack.popPose();
    }

    protected void applyModelScale(IPoseStack poseStack, M model) {
        IModelBabyPose babyPose = model.getBabyPose();
        if (babyPose != null) {
            float scale = 1.0f / babyPose.getHeadScale();
            IVector3f offset = babyPose.getHeadOffset();
            poseStack.scale(scale, scale, scale);
            poseStack.translate(offset.getX() / 16.0f, offset.getY() / 16.0f, offset.getZ() / 16.0f);
        }
    }
}

