/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlotListView<M extends AbstractContainerMenu>
extends UIView {
    protected final M menu;
    protected final DelegateScreen<M> screen;
    private boolean isReady = false;

    public SlotListView(M menu, Inventory inventory, CGRect frame) {
        super(frame);
        this.menu = menu;
        this.screen = new DelegateScreen<M>(menu, inventory, (Component)Component.m_237113_((String)""));
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        UIWindow window = this.window();
        if (window != null) {
            this.screen.setup(this.convertRectToView(this.bounds(), null), window.bounds());
            this.isReady = true;
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        if (!this.isReady) {
            return;
        }
        int mouseX = (int)context.state().mousePos().getX();
        int mouseY = (int)context.state().mousePos().getY();
        CGPoint offset = this.screen.getContentOffset();
        context.saveGraphicsState();
        context.translateCTM(-offset.getX(), -offset.getY(), 0.0f);
        this.screen.renderInView(this, 400, mouseX, mouseY, context.state().partialTicks(), context);
        context.restoreGraphicsState();
    }

    @Override
    public void mouseDown(UIEvent event) {
        CGPoint pt = this.locationInScreen(event);
        this.screen.m_6375_(pt.x, pt.y, event.key());
    }

    @Override
    public void mouseUp(UIEvent event) {
        CGPoint pt = this.locationInScreen(event);
        this.screen.m_6348_(pt.x, pt.y, event.key());
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.screen.m_7861_();
    }

    public M getMenu() {
        return this.menu;
    }

    private CGPoint locationInScreen(UIEvent event) {
        CGPoint point = event.locationInWindow();
        UIWindow window = this.window();
        if (window != null) {
            CGRect frame = window.frame();
            return new CGPoint(point.x + frame.x, point.y + frame.y);
        }
        return point;
    }

    public static class DelegateScreen<M extends AbstractContainerMenu>
    extends AbstractMenuScreen<M> {
        private final Inventory inventory;

        public DelegateScreen(M menu, Inventory inventory, Component component) {
            super(menu, inventory, component);
            this.inventory = inventory;
            this.m_6575_(Minecraft.m_91087_(), 640, 480);
        }

        @Override
        public void m_7379_() {
        }

        public void setup(CGRect rect, CGRect bounds) {
            this.setContentSize(new CGSize(rect.width, rect.height));
            this.m_6574_(Minecraft.m_91087_(), (int)bounds.width, (int)bounds.height);
            this.setContentOffset(new CGPoint(rect.x, rect.y));
        }

        @Override
        public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
        }

        public void m_6597_(Slot slot, int i, int j, ClickType clickType) {
            if (slot != null) {
                this.f_97732_.m_150399_(slot.f_40219_, j, clickType, this.inventory.f_35978_);
            }
        }
    }
}

