/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix18;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SkinPreviewList<T>
extends UIView {
    protected UIEdgeInsets contentInset = new UIEdgeInsets(0.0f, 0.0f, 0.0f, 0.0f);
    protected CGSize itemSize = new CGSize(48.0f, 48.0f);
    protected UIFont font = UIFont.systemFont();
    protected Consumer<T> itemSelector;
    protected ArrayList<T> entries = new ArrayList();
    protected Ticket loadTicket = Ticket.list();
    protected int minimumLineSpacing = 1;
    protected int minimumInteritemSpacing = 1;
    protected int backgroundColor = -1071504862;
    private int rowCount;
    private int colCount;
    private int totalCount;
    private int hoveredIndex = -1;
    private boolean showsName = true;

    public SkinPreviewList(CGRect frame) {
        super(frame);
        this.reloadData();
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        if (this.itemSelector == null) {
            return;
        }
        int index = this.indexAtPoint(event.locationInView(this));
        if (index >= 0 && index < this.entries.size()) {
            this.itemSelector.accept(this.entries.get(index));
        }
    }

    @Override
    public void mouseEntered(UIEvent event) {
        super.mouseEntered(event);
        this.applyHovered(event);
    }

    @Override
    public void mouseMoved(UIEvent event) {
        super.mouseMoved(event);
        this.applyHovered(event);
    }

    @Override
    public void mouseExited(UIEvent event) {
        super.mouseExited(event);
        this.hoveredIndex = -1;
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.loadTicket.invalidate();
    }

    public ArrayList<T> getEntries() {
        return this.entries;
    }

    public void setEntries(ArrayList<T> entries) {
        this.loadTicket.invalidate();
        this.entries = new ArrayList<T>(entries);
    }

    public void reloadData() {
        float boxW = this.getInnerWidth() + (float)this.minimumInteritemSpacing;
        float boxH = this.getInnerHeight() + (float)this.minimumLineSpacing;
        this.colCount = Math.max(1, (int)Math.floor(boxW / (this.itemSize.width + (float)this.minimumInteritemSpacing)));
        this.rowCount = Math.max(1, (int)Math.floor(boxH / (this.itemSize.height + (float)this.minimumLineSpacing)));
        this.totalCount = this.rowCount * this.colCount;
    }

    @Override
    public CGSize sizeThatFits(CGSize size) {
        float boxW = size.width - this.contentInset.left - this.contentInset.right + (float)this.minimumInteritemSpacing;
        int colCount = Math.max(1, (int)Math.floor(boxW / (this.itemSize.width + (float)this.minimumInteritemSpacing)));
        int rowCount = Math.max(1, (this.entries.size() + colCount - 1) / colCount);
        float width = (this.itemSize.width + (float)this.minimumInteritemSpacing) * (float)colCount - (float)this.minimumInteritemSpacing;
        float height = (this.itemSize.height + (float)this.minimumLineSpacing) * (float)rowCount - (float)this.minimumLineSpacing;
        return new CGSize(this.contentInset.left + width + this.contentInset.right, this.contentInset.top + height + this.contentInset.bottom);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        int i;
        super.render(point, context);
        CGRect rect = this.bounds();
        float x = rect.x;
        float y = rect.y;
        float width = rect.width;
        float height = rect.height;
        if ((this.backgroundColor & 0xFF000000) != 0) {
            context.fillRect(x, y, x + width, y + height, this.backgroundColor);
        }
        IBufferSource buffers = AbstractBufferSource.defaultBufferSource();
        for (i = 0; i < this.totalCount; ++i) {
            this.renderItem(context, i, false, buffers);
        }
        buffers.endBatch();
        for (i = 0; i < this.totalCount; ++i) {
            this.renderItem(context, i, true, buffers);
        }
    }

    public void renderItem(CGGraphicsContext context, int index, boolean allowsHovered, IBufferSource bufferSource) {
        boolean isHovered;
        if (index >= this.entries.size()) {
            return;
        }
        T entry = this.entries.get(index);
        int row = index / this.colCount;
        int col = index % this.colCount;
        float ix = (this.itemSize.width + (float)this.minimumInteritemSpacing) * (float)col;
        float iy = (this.itemSize.height + (float)this.minimumLineSpacing) * (float)row;
        float iw = this.itemSize.width;
        float ih = this.itemSize.height;
        boolean bl = isHovered = index == this.hoveredIndex;
        if (isHovered != allowsHovered) {
            return;
        }
        CGRect clipBox = UIScreen.convertRectFromView(new CGRect(ix, iy, iw, ih), this);
        if (!context.boundingBoxOfClipPath().intersects(clipBox)) {
            return;
        }
        this.renderItemBackground(ix, iy, iw, ih, isHovered, entry, context);
        if (isHovered) {
            context.addClip(clipBox.insetBy(1.0f, 1.0f, 1.0f, 1.0f));
        }
        this.renderItemContent(ix, iy, iw, ih, isHovered, entry, bufferSource, context);
        if (isHovered) {
            bufferSource.endBatch();
            context.removeClip();
        }
    }

    public void renderItemContent(float x, float y, float width, float height, boolean isHovered, T entry, IBufferSource bufferSource, CGGraphicsContext context) {
        ResourceLocation texture;
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.getItemDescriptor(entry), this.loadTicket);
        if (bakedSkin == null) {
            int speed = 60;
            int frames = 18;
            int frame = (int)(System.currentTimeMillis() / (long)speed % (long)frames);
            int u = MathUtils.floor((float)frame / 9.0f);
            int v = frame - u * 9;
            context.drawResizableImage(ModTextures.SKIN_PANEL, x + 8.0f, y + 8.0f, width - 16.0f, height - 16.0f, u * 28, v * 28, 27.0f, 27.0f, 256.0f, 256.0f);
            return;
        }
        if (this.showsName) {
            NSString name = new NSString(this.getItemName(entry));
            List<NSString> properties = name.split(this.font, width - 2.0f);
            float iy = y + height - (float)properties.size() * this.font.lineHeight() - 2.0f;
            context.drawText(properties, x + 1.0f, iy, -1118482, false, this.font, 0.0f);
        }
        if ((texture = ArmourersWorkshop.getItemIcon(bakedSkin.getType())) != null) {
            context.drawResizableImage(texture, x + 1.0f, y + 1.0f, width / 4.0f, height / 4.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        float dx = x + width / 2.0f;
        float dy = y + height / 2.0f;
        float dw = width;
        float dh = height;
        if (isHovered) {
            dw *= 1.5f;
            dh *= 1.5f;
        }
        float tx = dx - dw / 2.0f;
        float ty = dy - dh / 2.0f;
        ExtendedItemRenderer.renderSkinInGUI(bakedSkin, tx, ty, 100.0f, dw, dh, 20.0f, 45.0f, 0.0f, context.state().ctm(), bufferSource);
    }

    public void renderItemBackground(float x, float y, float width, float height, boolean isHovered, T entry, CGGraphicsContext context) {
        int backgroundColor = this.getItemBackgroundColor(entry, isHovered);
        int borderColor = this.getItemBorderColor(entry, isHovered);
        context.fillRect(x, y, x + width, y + height, backgroundColor);
        context.fillRect(x, y + 1.0f, x + 1.0f, y + height, borderColor);
        context.fillRect(x, y, x + width - 1.0f, y + 1.0f, borderColor);
        context.fillRect(x + 1.0f, y + height - 1.0f, x + width, y + height, borderColor);
        context.fillRect(x + width - 1.0f, y, x + width, y + height - 1.0f, borderColor);
        Fix18.enableAlphaTest(RenderSystem.class);
    }

    public CGSize getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(CGSize itemSize) {
        this.itemSize = itemSize;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean showsName() {
        return this.showsName;
    }

    public void setShowsName(boolean showsName) {
        this.showsName = showsName;
    }

    public Consumer<T> getItemSelector() {
        return this.itemSelector;
    }

    public void setItemSelector(Consumer<T> itemSelector) {
        this.itemSelector = itemSelector;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    protected abstract String getItemName(T var1);

    protected abstract SkinDescriptor getItemDescriptor(T var1);

    protected int getItemBackgroundColor(T entry, boolean isHovered) {
        if (isHovered) {
            return -1065912559;
        }
        return 0x22AAAAAA;
    }

    protected int getItemBorderColor(T entry, boolean isHovered) {
        if (isHovered) {
            return -863467503;
        }
        return 0x22FFFFFF;
    }

    private float getInnerWidth() {
        return this.bounds().width - this.contentInset.left - this.contentInset.right;
    }

    private float getInnerHeight() {
        return this.bounds().height - this.contentInset.top - this.contentInset.bottom;
    }

    private void applyHovered(UIEvent event) {
        this.hoveredIndex = this.indexAtPoint(event.locationInView(this));
    }

    private int indexAtPoint(CGPoint point) {
        int col = (int)(point.x / (this.itemSize.width + (float)this.minimumInteritemSpacing));
        int row = (int)(point.y / (this.itemSize.height + (float)this.minimumLineSpacing));
        if (col < 0 || row < 0 || col >= this.colCount || row >= this.rowCount) {
            return -1;
        }
        return row * this.colCount + col;
    }
}

