/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInventoryView
extends UIView {
    private Style style = Style.NORMAL;
    private final UIImage compactImage = UIImage.of(ModTextures.COMMON).uv(0.0f, 180.0f).build();
    private final UIImage backgroundImage = UIImage.of(ModTextures.PLAYER_INVENTORY).build();
    private final UILabel nameLabel = new UILabel(new CGRect(8.0f, 5.0f, 100.0f, 9.0f));

    public PlayerInventoryView(CGRect frame) {
        super(frame);
        this.nameLabel.setFrame(new CGRect(8.0f, 5.0f, frame.width - 16.0f, 9.0f));
        this.nameLabel.setAutoresizingMask(34);
        this.addSubview(this.nameLabel);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        switch (this.style.ordinal()) {
            case 0: {
                context.drawImage(this.backgroundImage, this.bounds());
                break;
            }
            case 1: {
                context.drawImage(this.compactImage, this.bounds().insetBy(15.0f, 7.0f, 7.0f, 7.0f));
            }
        }
        super.render(point, context);
    }

    public NSString name() {
        return this.nameLabel.text();
    }

    public void setName(NSString name) {
        this.nameLabel.setText(name);
    }

    public Style style() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public static enum Style {
        NORMAL,
        COMPACT,
        NONE;

    }
}

