/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.model.BakedModel.ABI;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinModelManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class BakedItemTransform
implements ISkinTransform {
    private Entity entity;
    private ItemStack itemStack = ItemStack.f_41583_;
    private AbstractItemTransformType transformType = AbstractItemTransformType.NONE;
    private final ISkinPartType partType;
    private final BakedItemModel itemModel;

    public BakedItemTransform(BakedSkinPart bakedSkinPart, BakedSkin bakedSkin) {
        this.partType = bakedSkinPart.getType();
        this.itemModel = bakedSkin.getItemModel();
    }

    public void setup(Entity entity, SkinItemSource itemSource) {
        this.entity = entity;
        this.transformType = itemSource.getTransformType();
        this.itemStack = itemSource.getItem();
    }

    @Override
    public void apply(IPoseStack poseStack) {
        if (this.entity == null) {
            return;
        }
        BakedModel model = SkinModelManager.getInstance().getModel(this.partType, this.itemModel, this.itemStack, this.entity);
        float f1 = 16.0f;
        float f2 = 0.0625f;
        boolean flag = this.transformType.isLeftHand();
        poseStack.scale(f1, f1, f1);
        ABI.applyTransform(model, poseStack, flag, this.transformType);
        poseStack.scale(f2, f2, f2);
        if (flag) {
            poseStack.scale(-1.0f, 1.0f, 1.0f);
        }
    }
}

