/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.block.model.ItemTransform.Constructor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.item.ItemProperties.ABI;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedItemModel
extends BuiltInModel {
    public static final BakedItemModel DEFAULT = BakedItemModel.from(new DefaultItemTransforms(), false);
    private final Variant[] variants;

    public BakedItemModel(ItemTransforms itemTransforms, Variant[] variants, boolean usesBlockLight) {
        super(itemTransforms, ItemOverrides.f_111734_, BakedItemModel.getMissingAtlasSprite(), usesBlockLight);
        this.variants = variants;
    }

    public BakedModel resolve(BakedModel bakedModel, ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
        for (Variant variant : this.variants) {
            if (!variant.test(itemStack, level, entity, i)) continue;
            return variant.model;
        }
        return bakedModel;
    }

    public static BakedItemModel from(SkinItemTransforms itemTransforms, boolean usesBlockLight) {
        return BakedItemModel.from(Collections.emptyList(), itemTransforms, usesBlockLight);
    }

    public static BakedItemModel from(Collection<String> overrideNames, SkinItemTransforms itemTransforms, boolean usesBlockLight) {
        Baker baker = new Baker(itemTransforms, usesBlockLight);
        ArrayList<Variant> entries = new ArrayList<Variant>();
        for (String name : overrideNames) {
            ResourceLocation registryName = new ResourceLocation(name);
            BakedItemModel model = baker.bake(name, new Variant[0]);
            entries.add(new Variant(registryName, (BakedModel)model));
        }
        return baker.bake("", entries.toArray(new Variant[0]));
    }

    private static TextureAtlasSprite getMissingAtlasSprite() {
        return Minecraft.m_91087_().m_91304_().m_119409_().m_6160_();
    }

    public static class Variant {
        private final ResourceLocation name;
        private final BakedModel model;

        public Variant(ResourceLocation name, BakedModel model) {
            this.name = name;
            this.model = model;
        }

        public boolean test(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
            ItemPropertyFunction func = ABI.getProperty(ItemProperties.class, itemStack, this.name);
            if (func != null) {
                return func.m_141951_(itemStack, level, entity, i) >= 1.0f;
            }
            return false;
        }
    }

    public static class Baker {
        private String prefix = "";
        private final boolean usesBlockLight;
        private final SkinItemTransforms itemTransforms;

        public Baker(SkinItemTransforms itemTransforms, boolean usesBlockLight) {
            this.itemTransforms = itemTransforms;
            this.usesBlockLight = usesBlockLight;
        }

        public BakedItemModel bake(String prefix, Variant[] entries) {
            this.prefix = prefix;
            return new BakedItemModel(this.getTransforms(), entries, this.usesBlockLight);
        }

        private ItemTransforms getTransforms() {
            ItemTransform thirdPersonLeftHand = this.getTransform(AbstractItemTransformType.THIRD_PERSON_LEFT_HAND);
            ItemTransform thirdPersonRightHand = this.getTransform(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND);
            ItemTransform firstPersonLeftHand = this.getTransform(AbstractItemTransformType.FIRST_PERSON_LEFT_HAND);
            ItemTransform firstPersonRightHand = this.getTransform(AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND);
            ItemTransform head = this.getTransform(AbstractItemTransformType.HEAD);
            ItemTransform gui = this.getTransform(AbstractItemTransformType.GUI);
            ItemTransform ground = this.getTransform(AbstractItemTransformType.GROUND);
            ItemTransform fixed = this.getTransform(AbstractItemTransformType.FIXED);
            return new ItemTransforms(thirdPersonLeftHand, thirdPersonRightHand, firstPersonLeftHand, firstPersonRightHand, head, gui, ground, fixed);
        }

        private ItemTransform getTransform(AbstractItemTransformType key) {
            ITransformf transform = (ITransformf)this.itemTransforms.get(this.prefix + ";" + key.getName());
            if (transform == null) {
                transform = this.itemTransforms.get(key);
            }
            return Constructor.from(ItemTransform.class, transform);
        }
    }

    public static class DefaultItemTransforms
    extends SkinItemTransforms {
        public DefaultItemTransforms() {
            this.put(AbstractItemTransformType.GUI, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(30.0f, 135.0f, 0.0f), DefaultItemTransforms.scale(1.0f, 1.0f, 1.0f));
            this.put(AbstractItemTransformType.FIXED, DefaultItemTransforms.translate(0.0f, 0.0f, -2.0f), DefaultItemTransforms.rotation(0.0f, 0.0f, 0.0f), DefaultItemTransforms.scale(1.0f, 1.0f, 1.0f));
            this.put(AbstractItemTransformType.GROUND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 0.0f, 0.0f), DefaultItemTransforms.scale(0.5f, 0.5f, 0.5f));
            this.put(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.THIRD_PERSON_LEFT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.FIRST_PERSON_LEFT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
        }

        private void put(AbstractItemTransformType key, Vector3f translate, Vector3f rotation, Vector3f scale) {
            this.put(key, SkinTransform.create(translate, rotation, scale));
        }

        private static Vector3f translate(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }

        private static Vector3f rotation(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }

        private static Vector3f scale(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }
    }
}

