/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class RotableContainerBlockEntity
extends UpdatableContainerBlockEntity
implements IBlockEntityHandler {
    public static final AABB ZERO_BOX = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private AABB renderBoundingBox;

    public RotableContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setRenderChanged() {
        this.renderBoundingBox = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rectangle3f getRenderShape(BlockState blockState) {
        return null;
    }

    @Override
    public AABB getRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        Rectangle3f rect = this.getRenderShape(blockState);
        if (rect == null) {
            return ZERO_BOX;
        }
        OpenQuaternionf quaternion = this.getRenderRotations(blockState);
        if (quaternion != null) {
            rect.mul(quaternion);
        }
        this.renderBoundingBox = rect.offset(Vector3d.atCenterOf(this.m_58899_())).asAABB();
        return this.renderBoundingBox;
    }
}

