/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.AnimationModifier;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DefaultOverriddenArmaturePlugin
extends ArmaturePlugin {
    private final ArrayList<IModelPart> applying = new ArrayList();
    private final HashMap<ISkinProperty<Boolean>, Collection<? extends IModelPart>> overrides = new HashMap();
    private final HashMap<ISkinType, Collection<? extends IModelPart>> skinTypeToOverrides = new HashMap();
    private final HashMap<ISkinPartType, Collection<? extends IModelPart>> skinPartTypeToOverrides = new HashMap();

    public DefaultOverriddenArmaturePlugin(Map<String, Collection<String>> keys, ArmatureTransformerContext context) {
        context.addEntityModelListener(model -> this.buildOverrides((IModel)model, keys));
    }

    @Override
    public void prepare(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        if (entity instanceof LivingEntity && renderData.isLimitLimbs()) {
            AnimationModifier.applyLimitLimbs((LivingEntity)entity);
        }
    }

    @Override
    public void activate(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        SkinOverriddenManager overriddenManager = renderData.getOverriddenManager();
        overriddenManager.willRender(entity);
        this.overrides.forEach((key, value) -> {
            if (overriddenManager.contains((ISkinProperty<Boolean>)key)) {
                this.hidden((Collection<? extends IModelPart>)value);
            }
        });
        this.skinTypeToOverrides.forEach((key, value) -> {
            if (this.has(key, SkinTypes.UNKNOWN, renderData.getUsingTypes())) {
                this.hidden((Collection<? extends IModelPart>)value);
            }
        });
        this.skinPartTypeToOverrides.forEach((key, value) -> {
            if (this.has(key, SkinPartTypes.UNKNOWN, renderData.getUsingPartTypes())) {
                this.hidden((Collection<? extends IModelPart>)value);
            }
        });
    }

    @Override
    public void deactivate(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        SkinOverriddenManager overriddenManager = renderData.getOverriddenManager();
        overriddenManager.didRender(entity);
        this.applying.forEach(it -> it.setVisible(true));
        this.applying.clear();
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    private <T> boolean has(T value, T anyValue, Collection<T> list) {
        if (value != anyValue) {
            return list.contains(value);
        }
        return !list.isEmpty();
    }

    private void hidden(Collection<? extends IModelPart> parts) {
        if (ModDebugger.modelOverride) {
            return;
        }
        for (IModelPart iModelPart : parts) {
            if (!iModelPart.isVisible()) continue;
            iModelPart.setVisible(false);
            this.applying.add(iModelPart);
        }
    }

    private void buildOverrides(IModel model, Map<String, Collection<String>> keys) {
        this.overrides.clear();
        keys.forEach((key, names) -> {
            if (key.startsWith("hasType.")) {
                ISkinType skinType = SkinTypes.byName(key.replace("hasType.", "armourers:"));
                this.skinTypeToOverrides.put(skinType, this.buildParts((Collection<String>)names, model));
                return;
            }
            if (key.startsWith("hasPart.")) {
                ISkinPartType skinPartType = SkinPartTypes.byName(key.replace("hasPart.", "armourers:"));
                this.skinPartTypeToOverrides.put(skinPartType, this.buildParts((Collection<String>)names, model));
                return;
            }
            SkinProperty<Boolean> property = SkinProperty.normal(key, false);
            this.overrides.put(property, this.buildParts((Collection<String>)names, model));
        });
    }

    private Collection<? extends IModelPart> buildParts(Collection<String> names, IModel model) {
        if (names.contains("*")) {
            return model.getAllParts();
        }
        LinkedHashMap<String, IModelPart> parts = new LinkedHashMap<String, IModelPart>();
        for (String name : names) {
            IModelPart part = model.getPart(name);
            if (part == null) continue;
            parts.put(name, part);
        }
        return parts.values();
    }
}

