/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.compatibility.client.layer.AbstractSkinnableLayers;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.layer.PlaceholderLayer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DefaultLayerArmaturePlugin
extends ArmaturePlugin {
    private final ArrayList<Entry> entries = new ArrayList();
    private final ArrayList<EntryImpl<?, ?>> applying = new ArrayList();

    public static DefaultLayerArmaturePlugin villager(ArmatureTransformerContext context) {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(AbstractSkinnableLayers.VILLAGER_PROFESSION, plugin::whenHeadVisible);
        context.addEntityModelListener(plugin::setEntityModel);
        context.addEntityRendererListener(plugin::setEntityRenderer);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin slime(ArmatureTransformerContext context) {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(AbstractSkinnableLayers.SLIME_OUTER, plugin::whenAnyVisible);
        context.addEntityModelListener(plugin::setEntityModel);
        context.addEntityRendererListener(plugin::setEntityRenderer);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin mob(ArmatureTransformerContext context) {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(AbstractSkinnableLayers.STRAY_CLOTHING, plugin::whenBodyVisible);
        plugin.register(AbstractSkinnableLayers.DROWNED_OUTER, plugin::whenBodyVisible);
        context.addEntityModelListener(plugin::setEntityModel);
        context.addEntityRendererListener(plugin::setEntityRenderer);
        return plugin;
    }

    @Override
    public void activate(Entity entity, SkinRenderContext context) {
        this.entries.forEach(it -> {
            if (!it.tester.get().booleanValue()) {
                it.impl.activate();
                this.applying.add(it.impl);
            }
        });
    }

    @Override
    public void deactivate(Entity entity, SkinRenderContext context) {
        this.applying.forEach((Consumer<EntryImpl<?, ?>>)((Consumer<EntryImpl>)EntryImpl::deactivate));
        this.applying.clear();
    }

    @Override
    public boolean freeze() {
        this.entries.removeIf(it -> it.tester == null || it.impl == null);
        return !this.entries.isEmpty();
    }

    private <T extends LivingEntity, M extends EntityModel<T>> void apply(LivingEntityRenderer<T, M> entityRenderer) {
        List layers = entityRenderer.f_115291_;
        for (RenderLayer targetLayer : layers) {
            for (Entry entry : this.entries) {
                if (!entry.layerClass.isInstance(targetLayer)) continue;
                EntryImpl impl = new EntryImpl();
                impl.target = targetLayer;
                impl.placeholder = new PlaceholderLayer<T, M>(entityRenderer);
                impl.layers = () -> entityRenderer.f_115291_;
                entry.impl = impl;
            }
        }
    }

    private void setEntityModel(IModel model) {
        this.entries.forEach(it -> {
            it.tester = it.testFactory.apply(model);
        });
    }

    private void setEntityRenderer(EntityRenderer<?> entityRenderer) {
        LivingEntityRenderer livingEntityRenderer = ObjectUtils.safeCast(entityRenderer, LivingEntityRenderer.class);
        if (livingEntityRenderer != null) {
            this.apply(livingEntityRenderer);
        }
    }

    private void register(Class<?> clazz, Function<IModel, Supplier<Boolean>> testFactory) {
        if (clazz != null) {
            Entry entry = new Entry();
            entry.layerClass = clazz;
            entry.testFactory = testFactory;
            this.entries.add(entry);
        }
    }

    private Supplier<Boolean> whenHeadVisible(IModel model) {
        IModelPart modelPart = model.getPart("head");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    private Supplier<Boolean> whenAnyVisible(IModel model) {
        Iterator<? extends IModelPart> iterator = model.getAllParts().iterator();
        if (iterator.hasNext()) {
            IModelPart part = iterator.next();
            return part::isVisible;
        }
        return null;
    }

    private Supplier<Boolean> whenBodyVisible(IModel model) {
        IModelPart modelPart = model.getPart("body");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    private static class Entry {
        Class<?> layerClass;
        Function<IModel, Supplier<Boolean>> testFactory;
        Supplier<Boolean> tester;
        EntryImpl<?, ?> impl;

        private Entry() {
        }
    }

    private static class EntryImpl<T extends Entity, M extends EntityModel<T>> {
        RenderLayer<T, M> target;
        RenderLayer<T, M> placeholder;
        Supplier<List<RenderLayer<T, M>>> layers;
        int lastIndex = 0;

        private EntryImpl() {
        }

        private void activate() {
            this.set(this.target, this.placeholder);
        }

        private void deactivate() {
            this.set(this.placeholder, this.target);
        }

        private void set(RenderLayer<T, M> from, RenderLayer<T, M> to) {
            List<RenderLayer<T, M>> layers = this.layers.get();
            if (this.lastIndex < layers.size() && layers.get(this.lastIndex) == from) {
                layers.set(this.lastIndex, to);
                return;
            }
            for (int index = 0; index < layers.size(); ++index) {
                if (layers.get(index) != from) continue;
                layers.set(index, to);
                this.lastIndex = index;
                break;
            }
        }
    }
}

