/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@Extension
public class OptionalAPI {
    public static boolean getOptionalBoolean(@This CompoundTag tag, String key, boolean defaultValue) {
        if (tag.m_128425_(key, 1)) {
            return tag.m_128471_(key);
        }
        return defaultValue;
    }

    public static void putOptionalBoolean(@This CompoundTag tag, String key, boolean value, boolean defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128379_(key, value);
        }
    }

    public static int getOptionalInt(@This CompoundTag tag, String key, int defaultValue) {
        if (tag.m_128425_(key, 3)) {
            return tag.m_128451_(key);
        }
        return defaultValue;
    }

    public static void putOptionalInt(@This CompoundTag tag, String key, int value, int defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128405_(key, value);
        }
    }

    public static float getOptionalFloat(@This CompoundTag tag, String key, float defaultValue) {
        if (tag.m_128425_(key, 5)) {
            return tag.m_128457_(key);
        }
        return defaultValue;
    }

    public static void putOptionalFloat(@This CompoundTag tag, String key, float value, float defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, Float.valueOf(value), Float.valueOf(defaultValue))) {
            tag.m_128350_(key, value);
        }
    }

    public static String getOptionalString(@This CompoundTag tag, String key, String defaultValue) {
        if (tag.m_128425_(key, 8)) {
            return tag.m_128461_(key);
        }
        return defaultValue;
    }

    public static void putOptionalString(@This CompoundTag tag, String key, String value, String defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128359_(key, value);
        }
    }

    public static <T extends IRegistryEntry> T getOptionalType(@This CompoundTag tag, String key, T defaultValue, Function<String, T> provider) {
        if (tag.m_128425_(key, 8)) {
            return (T)((IRegistryEntry)provider.apply(tag.m_128461_(key)));
        }
        return defaultValue;
    }

    public static <T extends IRegistryEntry> void putOptionalType(@This CompoundTag tag, String key, T value, T defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128359_(key, value.getRegistryName().toString());
        }
    }

    public static Vector3f getOptionalVector3f(@This CompoundTag tag, String key, Vector3f defaultValue) {
        ListTag listNBT = tag.m_128437_(key, 5);
        if (listNBT.size() >= 3) {
            return new Vector3f(listNBT.m_128775_(0), listNBT.m_128775_(1), listNBT.m_128775_(2));
        }
        return defaultValue;
    }

    public static void putOptionalVector3f(@This CompoundTag tag, String key, Vector3f value, Vector3f defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListTag tags = new ListTag();
            tags.add((Object)FloatTag.m_128566_((float)value.getX()));
            tags.add((Object)FloatTag.m_128566_((float)value.getY()));
            tags.add((Object)FloatTag.m_128566_((float)value.getZ()));
            tag.m_128365_(key, (Tag)tags);
        }
    }

    public static Vector3i getOptionalVector3i(@This CompoundTag tag, String key, Vector3i defaultValue) {
        ListTag listNBT = tag.m_128437_(key, 3);
        if (listNBT.size() >= 3) {
            return new Vector3i(listNBT.m_128763_(0), listNBT.m_128763_(1), listNBT.m_128763_(2));
        }
        return defaultValue;
    }

    public static void putOptionalVector3i(@This CompoundTag tag, String key, Vector3i value, Vector3i defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListTag tags = new ListTag();
            tags.add((Object)IntTag.m_128679_((int)value.getX()));
            tags.add((Object)IntTag.m_128679_((int)value.getY()));
            tags.add((Object)IntTag.m_128679_((int)value.getZ()));
            tag.m_128365_(key, (Tag)tags);
        }
    }

    public static Rectangle3i getOptionalRectangle3i(@This CompoundTag tag, String key, Rectangle3i defaultValue) {
        ListTag listTag = tag.m_128437_(key, 3);
        if (listTag.size() >= 6) {
            return new Rectangle3i(listTag.m_128763_(0), listTag.m_128763_(1), listTag.m_128763_(2), listTag.m_128763_(3), listTag.m_128763_(4), listTag.m_128763_(5));
        }
        return defaultValue;
    }

    public static void putOptionalRectangle3i(@This CompoundTag tag, String key, Rectangle3i value, Rectangle3i defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListTag tags = new ListTag();
            tags.add((Object)IntTag.m_128679_((int)value.getX()));
            tags.add((Object)IntTag.m_128679_((int)value.getY()));
            tags.add((Object)IntTag.m_128679_((int)value.getZ()));
            tags.add((Object)IntTag.m_128679_((int)value.getWidth()));
            tags.add((Object)IntTag.m_128679_((int)value.getHeight()));
            tags.add((Object)IntTag.m_128679_((int)value.getDepth()));
            tag.m_128365_(key, (Tag)tags);
        }
    }

    public static BlockPos getOptionalBlockPos(@This CompoundTag tag, String key, BlockPos defaultValue) {
        if (tag.m_128425_(key, 4)) {
            return BlockPos.m_122022_((long)tag.m_128454_(key));
        }
        return defaultValue;
    }

    public static void putOptionalBlockPos(@This CompoundTag tag, String key, BlockPos value, BlockPos defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128356_(key, value.m_121878_());
        }
    }

    public static Collection<BlockPos> getOptionalBlockPosArray(@This CompoundTag tag, String key) {
        ArrayList<BlockPos> elements = new ArrayList<BlockPos>();
        if (tag.m_128425_(key, 12)) {
            for (long value : tag.m_128467_(key)) {
                elements.add(BlockPos.m_122022_((long)value));
            }
        }
        return elements;
    }

    public static void putOptionalBlockPosArray(@This CompoundTag tag, String key, Collection<BlockPos> elements) {
        if (OptionalAPI._shouldPutValueArray(tag, key, elements)) {
            ArrayList<Long> list = new ArrayList<Long>(elements.size());
            for (BlockPos pos : elements) {
                list.add(pos.m_121878_());
            }
            tag.m_128428_(key, list);
        }
    }

    public static Rotations getOptionalRotations(@This CompoundTag tag, String key, Rotations defaultValue) {
        ListTag listTag = tag.m_128437_(key, 5);
        if (listTag.size() >= 3) {
            return new Rotations(listTag);
        }
        return defaultValue;
    }

    public static void putOptionalRotations(@This CompoundTag tag, String key, Rotations value, Rotations defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.m_123155_());
        }
    }

    public static GameProfile getOptionalGameProfile(@This CompoundTag tag, String key, GameProfile defaultValue) {
        CompoundTag profileTag = tag.m_128469_(key);
        if (profileTag.m_128456_()) {
            return defaultValue;
        }
        GameProfile value = DataSerializers.readGameProfile(profileTag);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static void putOptionalGameProfile(@This CompoundTag tag, String key, GameProfile value, GameProfile defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            CompoundTag profileTag = new CompoundTag();
            DataSerializers.writeGameProfile(profileTag, value);
            if (!profileTag.m_128456_()) {
                tag.m_128365_(key, (Tag)profileTag);
            }
        }
    }

    public static PlayerTextureDescriptor getOptionalTextureDescriptor(@This CompoundTag tag, String key, PlayerTextureDescriptor defaultValue) {
        CompoundTag nbt1;
        if (tag.m_128425_(key, 10) && !(nbt1 = tag.m_128469_(key)).m_128456_()) {
            return new PlayerTextureDescriptor(nbt1);
        }
        return defaultValue;
    }

    public static void putOptionalTextureDescriptor(@This CompoundTag tag, String key, PlayerTextureDescriptor value, PlayerTextureDescriptor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    @Nullable
    public static SkinPaintData getOptionalPaintData(@This CompoundTag tag, String key) {
        if (tag != null && tag.m_128425_(key, 7)) {
            try {
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])tag.m_128463_(key));
                ByteBufInputStream bufferedStream = new ByteBufInputStream(buffer);
                GZIPInputStream compressedStream = new GZIPInputStream((InputStream)bufferedStream);
                DataInputStream dataStream = new DataInputStream(compressedStream);
                SkinPaintData paintData = SkinPaintData.v2();
                int length = dataStream.readInt();
                int[] colors = paintData.getData();
                for (int i = 0; i < length; ++i) {
                    if (i >= colors.length) continue;
                    colors[i] = dataStream.readInt();
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                return paintData;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public static void putOptionalPaintData(@This CompoundTag tag, String key, SkinPaintData paintData) {
        if (paintData != null) {
            try {
                int[] colors = paintData.getData();
                ByteBuf buffer = Unpooled.buffer();
                ByteBufOutputStream bufferedStream = new ByteBufOutputStream(buffer);
                GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)bufferedStream);
                DataOutputStream dataStream = new DataOutputStream(compressedStream);
                dataStream.writeInt(colors.length);
                for (int color : colors) {
                    dataStream.writeInt(color);
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                tag.m_128382_(key, Arrays.copyOf(buffer.array(), buffer.writerIndex()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ColorScheme getOptionalColorScheme(@This CompoundTag tag, String key, ColorScheme defaultValue) {
        if (tag.m_128425_(key, 10)) {
            return new ColorScheme(tag.m_128469_(key));
        }
        return defaultValue;
    }

    public static void putOptionalColorScheme(@This CompoundTag tag, String key, ColorScheme value, ColorScheme defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    public static IPaintColor getOptionalPaintColor(@This CompoundTag tag, String key, IPaintColor defaultValue) {
        if (tag != null && tag.m_128425_(key, 3)) {
            return PaintColor.of(tag.m_128451_(key));
        }
        return defaultValue;
    }

    public static void putOptionalPaintColor(@This CompoundTag tag, String key, IPaintColor value, IPaintColor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128405_(key, value.getRawValue());
        }
    }

    public static SkinItemTransforms getOptionalItemTransforms(@This CompoundTag tag, String key, SkinItemTransforms defaultValue) {
        if (tag.m_128425_(key, 10)) {
            return new SkinItemTransforms(tag.m_128469_(key));
        }
        return defaultValue;
    }

    public static void putOptionalItemTransforms(@This CompoundTag tag, String key, SkinItemTransforms value, SkinItemTransforms defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    public static BlockPaintColor getOptionalBlockPaintColor(@This CompoundTag tag, String key, BlockPaintColor defaultValue) {
        if (!tag.m_128425_(key, 10)) {
            return defaultValue;
        }
        CompoundTag colorNBT = tag.m_128469_(key);
        if (colorNBT.m_128456_()) {
            return defaultValue;
        }
        BlockPaintColor color = new BlockPaintColor();
        color.deserializeNBT(colorNBT);
        return color;
    }

    public static void putOptionalBlockPaintColor(@This CompoundTag tag, String key, BlockPaintColor value, BlockPaintColor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    public static SkinDescriptor getOptionalSkinDescriptor(@This CompoundTag tag, String key) {
        return OptionalAPI.getOptionalSkinDescriptor(tag, key, SkinDescriptor.EMPTY);
    }

    public static void putOptionalSkinDescriptor(@This CompoundTag tag, String key, SkinDescriptor value) {
        OptionalAPI.putOptionalSkinDescriptor(tag, key, value, SkinDescriptor.EMPTY);
    }

    public static SkinDescriptor getOptionalSkinDescriptor(@This CompoundTag tag, String key, SkinDescriptor defaultValue) {
        CompoundTag parsedTag = OptionalAPI._parseCompoundTagFromSNBT(tag, key);
        if (parsedTag != null) {
            if (!parsedTag.m_128456_()) {
                return new SkinDescriptor(parsedTag);
            }
            return SkinDescriptor.EMPTY;
        }
        return defaultValue;
    }

    public static void putOptionalSkinDescriptor(@This CompoundTag tag, String key, SkinDescriptor value, SkinDescriptor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    public static SkinProperties getOptionalSkinProperties(@This CompoundTag tag, String key) {
        SkinProperties properties = new SkinProperties();
        if (tag.m_128425_(key, 10)) {
            properties.readFromNBT(tag.m_128469_(key));
        }
        return properties;
    }

    public static void putOptionalSkinProperties(@This CompoundTag tag, String key, SkinProperties properties) {
        if (OptionalAPI._shouldPutValue(tag, key, properties, SkinProperties.EMPTY)) {
            CompoundTag propertiesTag = new CompoundTag();
            properties.writeToNBT(propertiesTag);
            tag.m_128365_(key, (Tag)propertiesTag);
        }
    }

    public static SkinOptions getOptionalSkinOptions(@This CompoundTag tag, String key, SkinOptions defaultValue) {
        CompoundTag nbt1;
        if (tag.m_128425_(key, 10) && !(nbt1 = tag.m_128469_(key)).m_128456_()) {
            return new SkinOptions(nbt1);
        }
        return defaultValue;
    }

    public static void putOptionalSkinOptions(@This CompoundTag tag, String key, SkinOptions value, SkinOptions defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.m_128365_(key, (Tag)value.serializeNBT());
        }
    }

    public static Collection<SkinMarker> getOptionalSkinMarkerArray(@This CompoundTag tag, String key) {
        ArrayList<SkinMarker> elements = new ArrayList<SkinMarker>();
        if (tag.m_128425_(key, 12)) {
            for (long value : tag.m_128467_(key)) {
                elements.add(SkinMarker.of(value));
            }
        }
        return elements;
    }

    public static void putOptionalSkinMarkerArray(@This CompoundTag tag, String key, Collection<SkinMarker> elements) {
        if (OptionalAPI._shouldPutValueArray(tag, key, elements)) {
            ArrayList<Long> list = new ArrayList<Long>(elements.size());
            for (SkinMarker marker : elements) {
                list.add(marker.asLong());
            }
            tag.m_128428_(key, list);
        }
    }

    private static <T> boolean _shouldPutValue(CompoundTag tag, String key, T value, T defaultValue) {
        if (tag == null || key == null) {
            return false;
        }
        if (value == null || value.equals(defaultValue)) {
            tag.m_128473_(key);
            return false;
        }
        return true;
    }

    private static <T> boolean _shouldPutValueArray(CompoundTag tag, String key, Collection<T> value) {
        if (tag == null || key == null) {
            return false;
        }
        if (value == null || value.isEmpty()) {
            tag.m_128473_(key);
            return false;
        }
        return true;
    }

    private static CompoundTag _parseCompoundTagFromSNBT(CompoundTag tag, String key) {
        if (tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        if (tag.m_128425_(key, 8)) {
            return SkinFileUtils.readNBT(tag.m_128461_(key));
        }
        return null;
    }
}

