/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractMenuType<C extends AbstractContainerMenu>
implements IMenuType<C> {
    private ResourceLocation registryName;

    @Override
    public <T> InteractionResult openMenu(Player player, T value) {
        if (player == null || value == null) {
            return InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = ObjectUtils.safeCast(player, ServerPlayer.class);
        if (serverPlayer == null) {
            return InteractionResult.CONSUME;
        }
        IGlobalPos globalPos = this.getGlobalPos(value);
        if (globalPos != null) {
            return this.openMenu(serverPlayer, globalPos, null).orElse(InteractionResult.FAIL);
        }
        return this.openMenu(serverPlayer, this.getTitle(), value);
    }

    protected Optional<InteractionResult> openMenu(ServerPlayer player, IGlobalPos globalPos, Object extraData) {
        return globalPos.evaluate((level, blockPos) -> {
            if (!ModPermissions.OPEN.accept(this, (Level)level, (BlockPos)blockPos, (Player)player)) {
                return InteractionResult.FAIL;
            }
            return this.openMenu(player, this.getTitle(), globalPos);
        });
    }

    protected abstract <T> InteractionResult openMenu(ServerPlayer var1, Component var2, T var3);

    protected <T> IGlobalPos getGlobalPos(T value) {
        IGlobalPos globalPos = ObjectUtils.safeCast(value, IGlobalPos.class);
        if (globalPos != null) {
            return globalPos;
        }
        BlockEntity blockEntity = ObjectUtils.safeCast(value, BlockEntity.class);
        if (blockEntity != null) {
            return IGlobalPos.create(blockEntity.m_58904_(), blockEntity.m_58899_());
        }
        return null;
    }

    @Override
    public Component getTitle() {
        return TranslateUtils.title("inventory.armourers_workshop." + this.getRegistryName().m_135815_(), new Object[0]);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

