/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.impl.EntityRendererImpl;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRendererImpl {
    private static final EntityRendererImpl<LivingEntity> DEFAULT_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        context.saveGraphicsState();
        context.translateCTM(origin.x, origin.y, 0.0f);
        InventoryScreen.m_274545_((GuiGraphics)AbstractGraphicsRenderer.of(context), (int)0, (int)0, (int)scale, (float)focus.getX(), (float)focus.getY(), (LivingEntity)entity);
        context.restoreGraphicsState();
    };
    private static final EntityRendererImpl<Entity> CUSTOM_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        context.saveGraphicsState();
        context.translateCTM(origin.x, origin.y, 0.0f);
        float p = (float)Math.atan((0.0f - focus.getX()) / 40.0f);
        float q = (float)Math.atan((0.0f - focus.getY()) / 40.0f);
        OpenQuaternionf quaternion = Vector3f.ZP.rotationDegrees(180.0f);
        OpenQuaternionf quaternion2 = Vector3f.XP.rotationDegrees(q * 20.0f);
        quaternion.mul(Vector3f.YP.rotationDegrees(180.0f));
        quaternion.mul(quaternion2);
        float s = entity.m_146908_();
        float t = entity.m_146909_();
        entity.m_146922_(p * 40.0f);
        entity.m_146926_(-q * 20.0f);
        GuiGraphics guiGraphics = AbstractGraphicsRenderer.of(context);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 50.0);
        poseStack.m_252931_(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        ABI.mulPose(poseStack, quaternion);
        Lighting.m_166384_();
        EntityRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.conjugate();
        renderDispatcher.m_252923_(AbstractPoseStack.convertQuaternion(quaternion2));
        renderDispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> renderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0));
        guiGraphics.m_280262_();
        renderDispatcher.m_114468_(true);
        entity.m_146922_(s);
        entity.m_146926_(t);
        poseStack.m_85849_();
        Lighting.m_84931_();
        context.restoreGraphicsState();
    };

    public static <T extends Entity> EntityRendererImpl<T> getRenderer(T entity) {
        if (entity instanceof LivingEntity) {
            return DEFAULT_ENTITY_RENDERER;
        }
        return CUSTOM_ENTITY_RENDERER;
    }
}

