/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStackImpl;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractPoseStack
extends AbstractPoseStackImpl
implements IPoseStack {
    private final PoseStack stack;

    public AbstractPoseStack() {
        this(new PoseStack());
    }

    public AbstractPoseStack(PoseStack poseStack) {
        this.stack = poseStack;
    }

    public static IPoseStack wrap(PoseStack poseStack) {
        return IAssociatedObjectProvider.of(poseStack, AbstractPoseStack::new);
    }

    public static PoseStack unwrap(IPoseStack poseStack) {
        if (poseStack instanceof AbstractPoseStack) {
            return ((AbstractPoseStack)poseStack).stack;
        }
        PoseStack poseStack1 = new PoseStack();
        IPoseStack poseStack2 = AbstractPoseStack.wrap(poseStack1);
        poseStack2.last().set(poseStack.last());
        return poseStack1;
    }

    @Override
    public void pushPose() {
        this.stack.m_85836_();
    }

    @Override
    public void popPose() {
        this.stack.m_85849_();
    }

    @Override
    public void translate(float x, float y, float z) {
        this.stack.m_252880_(x, y, z);
    }

    @Override
    public void scale(float x, float y, float z) {
        Pose entry = this.last();
        entry.pose.scale(x, y, z);
        if (Math.abs(x) == Math.abs(y) && Math.abs(y) == Math.abs(z)) {
            if (x < 0.0f || y < 0.0f || z < 0.0f) {
                entry.normal.scale(Math.signum(x), Math.signum(y), Math.signum(z));
            }
        } else {
            entry.normal.scale(1.0f / x, 1.0f / y, 1.0f / z);
            entry.properties |= 2;
        }
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        ABI.mulPose(this.stack, quaternion);
    }

    @Override
    public void multiply(IMatrix3f matrix) {
        Pose entry = this.last();
        entry.normal.multiply(matrix);
    }

    @Override
    public void multiply(IMatrix4f matrix) {
        Pose entry = this.last();
        entry.pose.multiply(matrix);
    }

    @Override
    public void setIdentity() {
        this.stack.m_166856_();
    }

    @Override
    public Pose last() {
        return IAssociatedObjectProvider.of(this.stack.m_85850_(), Pose::new);
    }

    public static class Pose
    implements IPoseStack.Pose {
        private final AbstractPoseStackImpl.AbstractMatrix4f pose;
        private final AbstractPoseStackImpl.AbstractMatrix3f normal;
        private int properties;

        public Pose(PoseStack.Pose pose) {
            this.pose = new AbstractPoseStackImpl.AbstractMatrix4f(pose.m_252922_());
            this.normal = new AbstractPoseStackImpl.AbstractMatrix3f(pose.m_252943_());
            this.properties = 0;
        }

        @Override
        public void transformPose(float[] values) {
            this.pose.multiply(values);
        }

        @Override
        public void transformNormal(float[] values) {
            this.normal.multiply(values);
            if ((this.properties & 2) != 0) {
                MathUtils.normalize(values);
            }
        }

        @Override
        public void set(IPoseStack.Pose entry) {
            this.pose.set(entry.pose());
            this.normal.set(entry.normal());
            this.properties = entry.properties();
        }

        @Override
        public IMatrix4f pose() {
            return this.pose;
        }

        @Override
        public IMatrix3f normal() {
            return this.normal;
        }

        public void setProperties(int properties) {
            this.properties = properties;
        }

        @Override
        public int properties() {
            return this.properties;
        }
    }
}

