/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class AbstractBufferSource
implements IBufferSource {
    private static final Cache<Object, AbstractBufferSource> CACHED_BUFFER_SOURCES = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build();
    private final HashMap<VertexConsumer, IVertexConsumer> cachedBuffers = new HashMap();
    private final MultiBufferSource bufferSource;

    public AbstractBufferSource(MultiBufferSource bufferSource) {
        this.bufferSource = bufferSource;
    }

    public static IBufferSource defaultBufferSource() {
        return AbstractBufferSource.wrap((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
    }

    public static IBufferSource immediateBufferSource(BufferBuilder bufferBuilder) {
        return new AbstractBufferSource((MultiBufferSource)MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder));
    }

    public static IBufferSource wrap(MultiBufferSource bufferSource) {
        AbstractBufferSource bufferSource1 = (AbstractBufferSource)CACHED_BUFFER_SOURCES.getIfPresent((Object)bufferSource);
        if (bufferSource1 == null) {
            bufferSource1 = new AbstractBufferSource(bufferSource);
            CACHED_BUFFER_SOURCES.put((Object)bufferSource, (Object)bufferSource1);
        }
        return bufferSource1;
    }

    public static MultiBufferSource unwrap(IBufferSource bufferSource) {
        return ((AbstractBufferSource)bufferSource).bufferSource;
    }

    @Override
    public IVertexConsumer getBuffer(RenderType renderType) {
        VertexConsumer builder = this.bufferSource.m_6299_(renderType);
        return this.cachedBuffers.computeIfAbsent(builder, AbstractVertexConsumer::new);
    }

    @Override
    public void endBatch() {
        if (this.bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)this.bufferSource).m_109911_();
        }
    }
}

